package org.simantics.export.core.manager;

import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.intf.PublisherClass;

/**
 * This action publishes the prepared content into an output location.
 *
 * @author toni.kalajainen@semantum.fi
 */
public class PublishAction extends ExportAction {

	public String publisherId;
	public Variant locationOptions;
	public List<Content> contents;
	
	public PublishAction( String publisherId, Variant locationOptions, List<Content> contents ) 
	{
		this.publisherId = publisherId;
		this.locationOptions = locationOptions;
		this.contents = contents;
	}
	
	@Override
	public void execute(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
		Publisher publisher = ctx.eep.getPublisher(publisherId);
		PublisherClass action = publisher.publisherClass();
		action.publish(ctx, contents, options, locationOptions, progress);
	}

	@Override
	public String label(ExportContext ctx) {		
		Publisher publisher = ctx.eep.getPublisher(publisherId);
		return publisher.label();
	}

	@Override
	public int work(ExportContext ctx) {
		return 2;
	}

	@Override
	public List<String> validate(ExportContext ctx, Variant options) {
		try {
			Publisher publisher = ctx.eep.getPublisher(publisherId);
			PublisherClass action = publisher.publisherClass();
			return action.validate(ctx, contents, options, locationOptions);
		} catch (ExportException e) {
			return Collections.singletonList( e.getClass().getName()+": "+e.getMessage() );
		}		
	}

	@Override
	public void cleanup(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
	}

}
