package org.simantics.document.swt.core.base;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.simantics.utils.ui.SWTUtils;

public class ScrolledCompositeContent extends Composite implements Runnable {
	
	public ScrolledCompositeContent(Composite parent, int style) {
		super(parent, style);
	}
	
	public void refreshSize() {
		SWTUtils.asyncExec(this, this);
	}

	public void run() {

		if(isDisposed()) return;

		ScrolledComposite sc = (ScrolledComposite)getParent();
		int scWidth = sc.getSize().x;
		
		ScrollBar bar = sc.getVerticalBar();
		if(bar != null && bar.isVisible())
			scWidth -= bar.getSize().x;
		
		Point current = getSize();
		Point target = computeSize(scWidth, SWT.DEFAULT, true);
		
		if(!current.equals(target)) {
			setSize(target);
			sc.getParent().layout(true, true);
		}
		
	}
	
}
