/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.base;

import java.util.Collection;
import java.util.List;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetManager;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.server.io.JSONObjectUtils;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.utils.datastructures.Pair;

public abstract class PropertyWidgetManager<W> implements WidgetManager<SWTDocument, W> {

	@Override
	public String getProperty(SWTDocument document, JSONObject object, W widget, String property) {
		return null;
	}

	@Override
	public IEventCommand eventCommand(SWTDocument document, JSONObject object, W widget, ICommand command, CommandContext context) {
		return null;
	}

	public static CommandContext sendEvent(SWTDocument document, WidgetData wd, String event, Object target, CommandContextMutable context) {
		Collection<ICommand> commands = JSONObjectUtils.getCommands(wd.object);

		if(context == null) context = new CommandContextImpl();
		context.putValue("event", event);

		List<Pair<WidgetData, ICommand>> data = SWTViews.getTriggeredCommands(document, commands, "eventOut");

		return document.handleCommands(data, context, wd.widget);
	}

}