/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.io.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.utils.datastructures.Pair;

public interface SWTDocument extends Document {

    public static final Map<String,String> NO_PARAMETERS = Collections.emptyMap();

    IWorkbenchSite getSite();
	ISelectionProvider getSelectionProvider();
	Color getColor(org.simantics.datatypes.literal.RGB.Integer bean);
	Font getFont(org.simantics.datatypes.literal.Font bean);
	void post(AbstractEventHandler handler, CommandContextMutable context);
	CommandContext handleCommands(List<Pair<WidgetData, ICommand>> data, CommandContextMutable context, Object component);
	void layout();

    void displayError(String error);

}
