/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class DatabaseProxy
implements Runnable {
    private static boolean SMALL_PACKETS = false;
    private static int PORT = 8891;
    private boolean interrupted = false;
    private Map<String, String> databases = new HashMap<String, String>();
    private ServerSocket service = null;

    public DatabaseProxy() {
        this.databases.put("/public/", "192.168.3.11:9101");
        this.databases.put("FooBar", "localhost:6671");
    }

    public DatabaseProxy(String host, int port) {
        this.databases.put("/test/", String.valueOf(host) + ":" + port);
    }

    public void start() {
        Thread t = new Thread(this);
        this.init();
        t.start();
    }

    public void stop() {
        this.interrupted = true;
        if (this.service != null) {
            try {
                this.service.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getPort() {
        return PORT;
    }

    public void init() {
        try {
            this.service = new ServerSocket(PORT);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void run() {
        System.out.println("Accepting connections");
        int connectionNumber = 0;
        while (!this.interrupted) {
            try {
                final Socket socket = this.service.accept();
                String connectionName = "Connection" + ++connectionNumber;
                System.out.println(String.valueOf(connectionName) + ": Client connection accepted.");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DatabaseProxy.this.serve(socket);
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                Thread t = new Thread(runnable, connectionName);
                t.start();
            }
            catch (IOException e) {
                if (this.interrupted) break;
                e.printStackTrace();
            }
        }
        try {
            if (this.service != null) {
                this.service.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void serve(Socket socket) throws IOException {
        Socket dbSocket;
        String connectionName = Thread.currentThread().getName();
        BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        String line = input.readLine();
        String[] columns = line.split("\t");
        if (columns.length < 2) {
            System.out.println(String.valueOf(connectionName) + ": serve() Invalid connection string [1] '" + line + "'");
            out.write("ERROR Invalid connection string\n");
            return;
        }
        String command = columns[0];
        String param = columns[1];
        if ("CONNECT".equals(command)) {
            if (!this.databases.containsKey(param)) {
                System.out.println(String.valueOf(connectionName) + ": serve() Invalid database '" + param + "'");
                out.write("ERROR Invalid database '" + param + "'\n");
                return;
            }
            String address = this.databases.get(param);
            String[] split = address.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException(String.valueOf(connectionName) + ": address does not contain a port, missing ':' character");
            }
            InetSocketAddress dbAddress = new InetSocketAddress(split[0], Integer.parseInt(split[1]));
            dbSocket = new Socket();
            try {
                dbSocket.connect(dbAddress);
            }
            catch (IOException iOException) {
                System.out.println(String.valueOf(connectionName) + ":serve() Couldn't connect to database '" + param + "'");
                out.write("ERROR Couldn't connect to database '" + param + "'\n");
                return;
            }
        } else {
            System.out.println(String.valueOf(connectionName) + ": serve() Invalid command '" + command + "'");
            out.write("ERROR Invalid command '" + command + "'\n");
            return;
        }
        out.write("OK\n");
        out.flush();
        this.proxy(dbSocket, socket);
        dbSocket.close();
    }

    private void proxy(final Socket a, final Socket b) {
        Runnable ab = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[256];
                    while (a.isConnected() && b.isConnected()) {
                        int n = a.getInputStream().read(buffer);
                        if (n < 1) break;
                        if (SMALL_PACKETS) {
                            int i = 0;
                            while (i < n) {
                                b.getOutputStream().write(buffer, i, 1);
                                b.getOutputStream().flush();
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                ++i;
                            }
                            continue;
                        }
                        b.getOutputStream().write(buffer, 0, n);
                        b.getOutputStream().flush();
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        Runnable ba = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[256];
                    while (b.isConnected() && a.isConnected()) {
                        int n = b.getInputStream().read(buffer);
                        if (n < 1) break;
                        if (SMALL_PACKETS) {
                            int i = 0;
                            while (i < n) {
                                a.getOutputStream().write(buffer, i, 1);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                a.getOutputStream().flush();
                                ++i;
                            }
                            continue;
                        }
                        a.getOutputStream().write(buffer, 0, n);
                        a.getOutputStream().flush();
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        String t = Thread.currentThread().getName();
        Thread tab = new Thread(ab, String.valueOf(t) + " server->client");
        Thread tba = new Thread(ba, String.valueOf(t) + " client->server");
        tab.start();
        tba.start();
        try {
            while (tba.isAlive() && tab.isAlive()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DatabaseProxy proxy = new DatabaseProxy();
        proxy.init();
        proxy.run();
    }
}

