package org.simantics.datatypes.literal;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;


final public class Vec2i extends Bean {

	public static final Binding BINDING = Bindings.getBindingUnchecked(Vec2i.class);

	public int x;
	public int y;

	public Vec2i(int x, int y) {
		super(BINDING);
		this.x = x;
		this.y = y;
	}

	public boolean isZero() {
		return x==0 && y==0; 
	}
	
	public double norm1() {
		return Math.abs(x) + Math.abs(y);
	}
	
	public double norm2() {
		return Math.sqrt(x*x+y*y);
	}
	
	public double length() {
		return norm2();
	}
	
	public double dot(Vec2i other) {
		return x*other.x + y*other.y;
	}

	public Vec2i sum(Vec2i other) {
		return new Vec2i(x + other.x , y + other.y);
	}

	@Override
	public String toString() {
		return "Vec2i[x=" + x + ", y=" + y + "]";
	}
	
}
