package org.simantics.datatypes.literal;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;


final public class Vec2d extends Bean {

	public static final Binding BINDING = Bindings.getBindingUnchecked(Vec2d.class);

	public double x;
	public double y;

	public Vec2d(double x, double y) {
		super(BINDING);
		this.x = x;
		this.y = y;
	}

	public boolean isZero() {
		return x==0.0 && y==0.0; 
	}
	
	public double norm1() {
		return Math.abs(x) + Math.abs(y);
	}
	
	public double norm2() {
		return Math.sqrt(x*x+y*y);
	}
	
	public double length() {
		return norm2();
	}
	
	public double dot(Vec2d other) {
		return x*other.x + y*other.y;
	}

	public Vec2d sum(Vec2d other) {
		return new Vec2d(x + other.x , y + other.y);
	}

	public Vec2d subtraction(Vec2d other) {
		return new Vec2d(x - other.x , y - other.y);
	}

	@Override
	public String toString() {
		return "Vec2d[x=" + x + ", y=" + y + "]";
	}
	
}
