/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.common.imagers.ImageURLs;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.utils.ReflectionUtils;

public abstract class AbstractNode<T> implements IAdaptable {

    public final T data;
    public final Class<?> clazz;

    public AbstractNode(T data) {
        assert(data != null);
        this.data = data;
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    @Override
    public int hashCode() {
        return data.hashCode() + getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AbstractNode<?> other = (AbstractNode<?>) obj;
        return data.equals(other.data);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <A> A getAdapter(Class<A> adapter) {
        if(clazz == adapter)
            return (A) data;
        if(Imager.class == adapter)
            return (A) getImager();
        if(ImageURLs.class == adapter)
            return (A) getImageURLs();
        if(Labeler.class == adapter)
            return (A) getLabeler();
        return null;
    }

    protected Imager getImager() {
        return null;
    }

    protected ImageURLs getImageURLs() {
        return null;
    }

    protected Labeler getLabeler() {
        return null;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName();
    }

}
