/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;
import org.simantics.utils.datastructures.Pair;

public class ListAccessor<Range, T>
implements IRangeAccessor<Range, Collection<T>> {
    private Method getter;
    private Method adder;
    private Method remover;

    public ListAccessor(Method getter, Method adder, Method remover) {
        this.getter = getter;
        this.adder = adder;
        this.remover = remover;
    }

    @Override
    public Collection<T> get(Object element) throws MappingException {
        try {
            return (Collection)this.getter.invoke(element, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }

    @Override
    public boolean set(Range element, Collection<T> value) throws MappingException {
        Object current = this.get((Object)element);
        ArrayList<Pair> adding = new ArrayList<Pair>();
        ArrayList removing = new ArrayList();
        Iterator iterator = current.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (value.contains(e)) continue;
            removing.add(e);
        }
        int i = 0;
        for (T t : value) {
            if (!current.contains(t)) {
                adding.add(new Pair((Object)i, t));
            }
            ++i;
        }
        try {
            for (Object object : removing) {
                this.remover.invoke(element, object);
            }
            for (Pair pair : adding) {
                this.adder.invoke(element, pair.first, pair.second);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MappingException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MappingException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MappingException(invocationTargetException.getCause());
        }
        return removing.size() > 0 || adding.size() > 0;
    }
}

