/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleShortMap}s.
 *
 * @see HashDoubleShortMap
 * @see HashDoubleShortMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleShortMapFactory
        extends DoubleShortMapFactory<HashDoubleShortMapFactory>
        , HashContainerFactory<HashDoubleShortMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(
            @Nonnull double[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(
            @Nonnull Map<Double, Short> map);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5);



    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(
            @Nonnull double[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashDoubleShortMap newMutableMapOf(double k1, short v1);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
    @Nonnull
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(
            @Nonnull Map<Double, Short> map);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5);



    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
    @Nonnull
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);

    


    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(
            @Nonnull Map<Double, Short> map);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Map<Double, Short> map1,
            @Nonnull Map<Double, Short> map2,
            @Nonnull Map<Double, Short> map3,
            @Nonnull Map<Double, Short> map4,
            @Nonnull Map<Double, Short> map5);



    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMapOf(double k1, short v1);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
    @Nonnull
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
}
