/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.Strings;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Jsons
extends SimpleProcProvider {
    public Jsons() {
        super((Type.Codec.Encoder<StringBuilder>)Strings.TEXT_ENCODER, (Type.Codec.Decoder<CharSequence>)Strings.TEXT_DECODER, (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "jsonb_");
    }

    public static class BinEncoder
    extends BaseBinaryEncoder {
        byte[] toBytes(Object val, Context context) {
            return val.toString().getBytes(context.getCharset());
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            byte[] bytes = this.toBytes(value, context);
            buffer.writeByte(1);
            buffer.writeBytes(bytes);
        }
    }

    public static class BinDecoder
    extends BaseBinaryDecoder {
        @Override
        public Class<?> getDefaultClass() {
            return String.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            if (length < 1) {
                throw new IOException("Invalid length for jsonb");
            }
            byte version = buffer.readByte();
            if (version != 1) {
                throw new IOException("Invalid version for jsonb");
            }
            Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
            byte[] bytes = maxLength != null ? new byte[Math.min(maxLength, length)] : new byte[--length];
            buffer.readBytes(bytes);
            buffer.skipBytes(length - bytes.length);
            return new String(bytes, context.getCharset());
        }
    }
}

