/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.datetime.DateTimeFormat;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;

public class ISOTimeFormat
implements DateTimeFormat {
    private Parser parser = new Parser();
    private Printer printer = new Printer();
    private static final DateTimeFormatter PARSE_FMT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "+00").optionalEnd().optionalStart().appendOffset("+HH:mm", "+00").optionalEnd().toFormatter().withChronology(IsoChronology.INSTANCE);
    private static final DateTimeFormatter PRINT_FMT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "+00").optionalEnd().toFormatter().withChronology(IsoChronology.INSTANCE);
    private static final DateTimeFormatter PRINT_FMT2 = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalStart().appendOffset("+HH:mm", "+00").optionalEnd().toFormatter().withChronology(IsoChronology.INSTANCE);

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    static class Printer
    implements DateTimeFormat.Printer {
        Printer() {
        }

        @Override
        public String format(Temporal value) {
            if (value.isSupported(ChronoField.OFFSET_SECONDS) && value.get(ChronoField.OFFSET_SECONDS) % 3600 != 0) {
                return PRINT_FMT.format(value);
            }
            return PRINT_FMT2.format(value);
        }
    }

    static class Parser
    implements DateTimeFormat.Parser {
        Parser() {
        }

        @Override
        public TemporalAccessor parse(CharSequence time) {
            return PARSE_FMT.parse(time);
        }
    }
}

