/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.elevation.server;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.simantics.maps.elevation.server.Activator;
import org.simantics.maps.elevation.server.TiffTileInterface;
import org.simantics.maps.elevation.server.prefs.MapsElevationServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonTiffTileInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingletonTiffTileInterface.class);
    private static SingletonTiffTileInterface instance;
    private TiffTileInterface tileInterface;

    static {
        Activator.registerSpis();
    }

    private SingletonTiffTileInterface() {
        Path tilesFolder = Paths.get(MapsElevationServerPreferences.tifFolderPath(), new String[0]);
        try {
            Files.createDirectories(tilesFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create directories {}", (Object)tilesFolder.toAbsolutePath(), (Object)e);
        }
        LOGGER.info("Elevation server looking for tif files at {}", (Object)tilesFolder.toAbsolutePath());
        this.tileInterface = new TiffTileInterface(tilesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SingletonTiffTileInterface getInstance() {
        if (instance != null) return instance;
        Class<SingletonTiffTileInterface> clazz = SingletonTiffTileInterface.class;
        synchronized (SingletonTiffTileInterface.class) {
            if (instance != null) return instance;
            instance = new SingletonTiffTileInterface();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void reloadElevationServer() {
        block6: {
            if (instance != null) {
                try {
                    try {
                        SingletonTiffTileInterface.instance.tileInterface.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not close current elevation server interface", (Throwable)e);
                        instance = null;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    instance = null;
                    throw throwable;
                }
                instance = null;
            }
        }
        SingletonTiffTileInterface.getInstance();
    }

    public static double lookupd(double x, double y) {
        return SingletonTiffTileInterface.lookup(x, y).doubleValue();
    }

    public static Number lookup(double x, double y) {
        return SingletonTiffTileInterface.getInstance().tileInterface.lookup(x, y);
    }

    public static Collection<Rectangle2D> getBoundingBoxes() {
        return SingletonTiffTileInterface.getInstance().tileInterface.getBoundingBoxes();
    }
}

