/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.modifiers;

import java.util.ArrayList;
import java.util.List;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.content.Labeler;

public abstract class AbstractEnumerationModifier<T>
implements Labeler.EnumerationModifier {
    private final Enumeration<T> enumeration;
    private final EnumeratedValue<T> value;
    private final List<String> values;

    public AbstractEnumerationModifier(Enumeration<T> enumeration, EnumeratedValue<T> value) {
        assert (enumeration != null);
        assert (enumeration.size() > 0);
        this.enumeration = enumeration;
        this.value = value;
        this.values = new ArrayList<String>(enumeration.size());
        for (EnumeratedValue<T> v : enumeration.values()) {
            this.values.add(v.getName());
        }
    }

    public final List<String> getValues() {
        return this.values;
    }

    public final String getValue() {
        if (this.value != null) {
            return this.value.getName();
        }
        return this.enumeration.values().get(0).getName();
    }

    public final String isValid(String label) {
        if (!this.values.contains(label)) {
            return "Value '" + label + "' is not among the enumerated values " + this.values;
        }
        return null;
    }

    public final void modify(String label) {
        int index = this.values.indexOf(label);
        if (index == -1) {
            throw new IllegalArgumentException("Cannot modify enumeration with value '" + label + "', not among the enumerated values " + this.values);
        }
        this.modifyWithValue(this.value, this.enumeration.values().get(index));
    }

    protected void modifyWithValue(EnumeratedValue<T> oldEnumValue, EnumeratedValue<T> enumValue) {
        T oldObject = oldEnumValue != null ? (T)oldEnumValue.getObject() : null;
        T newObject = enumValue != null ? (T)enumValue.getObject() : null;
        this.modifyWithObject(oldObject, newObject);
    }

    protected void modifyWithObject(T oldEnumObject, T enumObject) {
    }
}

