/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.threads.IThreadWorkQueue;

public class AdaptableHintContext
implements IHintContext,
IAdaptable,
WorkbenchSelectionElement {
    private final IHintContext.Key[] keysToTry;
    protected final Map<IHintContext.Key, Object> hints;

    public AdaptableHintContext() {
        this(SelectionHints.STD_KEYS);
    }

    public AdaptableHintContext(IHintContext.Key ... keys) {
        this(new HashMap<IHintContext.Key, Object>(4), keys);
    }

    public AdaptableHintContext(Map<IHintContext.Key, Object> hints, IHintContext.Key ... keys) {
        if (hints == null) {
            throw new NullPointerException("null hints");
        }
        this.keysToTry = keys;
        this.hints = hints;
    }

    public Object getAdapter(Class adapter) {
        IHintContext.Key[] keyArray = this.keysToTry;
        int n = this.keysToTry.length;
        int n2 = 0;
        while (n2 < n) {
            Object adapted;
            IHintContext.Key key = keyArray[n2];
            Object o = this.getHint(key);
            if (adapter.isAssignableFrom(o.getClass())) {
                return o;
            }
            if (o instanceof IAdaptable && (adapted = ((IAdaptable)o).getAdapter(adapter)) != null) {
                return adapted;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getHints();
    }

    public void clearWithoutNotification() {
        this.hints.clear();
    }

    public boolean containsHint(IHintContext.Key key) {
        return this.hints.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E getHint(IHintContext.Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        AdaptableHintContext adaptableHintContext = this;
        synchronized (adaptableHintContext) {
            return (E)this.hints.get(key);
        }
    }

    public synchronized Map<IHintContext.Key, Object> getHints() {
        return new HashMap<IHintContext.Key, Object>(this.hints);
    }

    public Map<IHintContext.Key, Object> getHintsUnsafe() {
        return this.hints;
    }

    public <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        HashMap<IHintContext.Key, Object> result = null;
        for (Map.Entry<IHintContext.Key, Object> e : this.hints.entrySet()) {
            IHintContext.Key key = e.getKey();
            if (!clazz.isAssignableFrom(key.getClass())) continue;
            if (result == null) {
                result = new HashMap<IHintContext.Key, Object>(4);
            }
            result.put(key, e.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHint(IHintContext.Key key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!key.isValueAccepted(value)) {
            throw new RuntimeException("Value \"" + value + "\" is not accepted with key " + key.getClass().getName());
        }
        AdaptableHintContext adaptableHintContext = this;
        synchronized (adaptableHintContext) {
            this.hints.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHints(Map<IHintContext.Key, Object> hints) {
        AdaptableHintContext adaptableHintContext = this;
        synchronized (adaptableHintContext) {
            for (Map.Entry<IHintContext.Key, Object> e : hints.entrySet()) {
                IHintContext.Key key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    throw new IllegalArgumentException("a value is null for key " + e.getKey());
                }
                this.hints.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E removeHint(IHintContext.Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Object oldValue = null;
        AdaptableHintContext adaptableHintContext = this;
        synchronized (adaptableHintContext) {
            oldValue = this.hints.remove(key);
        }
        if (oldValue == null) {
            return null;
        }
        return (E)oldValue;
    }

    public void addHintListener(IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeHintListener(IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addKeyHintListener(IHintContext.Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeKeyHintListener(IHintContext.Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return (this.hints.hashCode() * 31 + Arrays.hashCode(this.keysToTry)) * 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdaptableHintContext other = (AdaptableHintContext)obj;
        return Arrays.equals(this.keysToTry, other.keysToTry) && Objects.equals(this.hints, other.hints);
    }

    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        return null;
    }
}

