/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Arrays;
import java.util.Iterator;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryIdentityHash;

public final class QueryIdentityHashSet
extends QueryIdentityHash
implements Iterable<CacheEntry> {
    private int knownBound = 10;

    public QueryIdentityHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public final boolean add(CacheEntry obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        CacheEntry old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        CacheEntry[] oldSet = this._set;
        this._set = new CacheEntry[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            CacheEntry o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                new Exception().printStackTrace();
                System.out.println("rehash " + i + " " + o);
                int j = oldCapacity;
                while (j-- > 0) {
                    System.out.println("rehash " + j + " " + oldSet[j] + " " + System.identityHashCode(oldSet[j]));
                }
                continue;
            }
            this._set[index] = o;
        }
    }

    public final boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final void purge() {
        if (this.size() > this.knownBound << 1) {
            this.knownBound = 10;
            int i = 0;
            while (i < this._set.length) {
                CacheEntry entry = this._set[i];
                if (entry != null && REMOVED != entry) {
                    if (entry.isDiscarded()) {
                        this.removeAt(i);
                    } else {
                        ++this.knownBound;
                    }
                }
                ++i;
            }
        }
    }

    public final CacheEntry removeDiscarded() {
        this.tempDisableAutoCompaction();
        try {
            int i = 0;
            while (i < this._set.length) {
                CacheEntry entry = this._set[i];
                if (entry != null && REMOVED != entry) {
                    this.removeAt(i);
                    if (!entry.isDiscarded()) {
                        CacheEntry cacheEntry = entry;
                        return cacheEntry;
                    }
                }
                ++i;
            }
            return null;
        }
        finally {
            this.reenableAutoCompaction(false);
        }
    }

    public final void removeDiscardedReally() {
        this.tempDisableAutoCompaction();
        try {
            int i = 0;
            while (i < this._set.length) {
                CacheEntry entry = this._set[i];
                if (entry != null && REMOVED != entry && entry.isDiscarded()) {
                    this.removeAt(i);
                }
                ++i;
            }
        }
        finally {
            this.reenableAutoCompaction(false);
        }
    }

    @Override
    public final Iterator<CacheEntry> iterator() {
        class Iter
        implements Iterator<CacheEntry> {
            private int index;

            public Iter() {
                this.index = QueryIdentityHashSet.this.capacity();
                this.advance();
            }

            private void advance() {
                while (this.index-- > 0 && (QueryIdentityHashSet.this._set[this.index] == null || QueryIdentityHashSet.this._set[this.index] == QueryIdentityHash.REMOVED)) {
                }
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public CacheEntry next() {
                if (this.index >= 0) {
                    CacheEntry result = QueryIdentityHashSet.this._set[this.index];
                    this.advance();
                    return result;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new Error("Not supported.");
            }
        }
        return new Iter();
    }

    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, null);
    }
}

