/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variables;

public class RVIBuilder {
    Binding rviBinding;
    List<RVI.RVIPart> parts;

    public RVIBuilder(Binding rviBinding) {
        this.parts = new ArrayList<RVI.RVIPart>();
    }

    public RVIBuilder(RVI rvi) {
        this.set(rvi);
    }

    public RVIBuilder set(RVI rvi) {
        this.rviBinding = rvi.getBinding();
        this.parts = new ArrayList<RVI.RVIPart>(rvi.parts.length + 10);
        RVI.RVIPart[] rVIPartArray = rvi.parts;
        int n = rvi.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVI.RVIPart part = rVIPartArray[n2];
            this.parts.add(part);
            ++n2;
        }
        return this;
    }

    public RVIBuilder append(RVI rvi) {
        RVI.RVIPart[] rVIPartArray = rvi.parts;
        int n = rvi.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVI.RVIPart part = rVIPartArray[n2];
            this.parts.add(part);
            ++n2;
        }
        return this;
    }

    public RVIBuilder append(RVI.RVIPart part) {
        this.parts.add(part);
        return this;
    }

    public RVIBuilder append(Variables.Role role, String string) {
        this.parts.add(new RVI.StringRVIPart(role, string));
        return this;
    }

    public RVIBuilder append(Variables.Role role, Resource resource) {
        this.parts.add(new RVI.ResourceRVIPart(role, resource));
        return this;
    }

    public RVIBuilder append(Variables.Role role, Resource resource, long mostSignificant, long leastSignificant) {
        this.parts.add(new RVI.GuidRVIPart(role, resource, mostSignificant, leastSignificant));
        return this;
    }

    public RVIBuilder removeLast(int n) {
        if (n > this.parts.size()) {
            throw new IllegalArgumentException("Requested to remove " + n + " parts from RVI, only " + this.parts.size() + " parts exist in '" + this.parts + "'");
        }
        this.parts = this.parts.subList(0, this.parts.size() - n);
        return this;
    }

    public RVIBuilder removeFromFirstRole(Variables.Role role) {
        int i = 0;
        while (i < this.parts.size()) {
            if (this.parts.get(i).getRole() == role) {
                this.parts = this.parts.subList(0, i);
                return this;
            }
            ++i;
        }
        return this;
    }

    public RVI toRVI() {
        if (this.parts.isEmpty()) {
            return RVI.empty(this.rviBinding);
        }
        RVI rvi = new RVI(this.rviBinding);
        rvi.parts = this.parts.toArray(new RVI.RVIPart[this.parts.size()]);
        return rvi;
    }
}

