/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleActiveVariableFromVariable
extends UnaryRead<Variable, Variable> {
    public PossibleActiveVariableFromVariable(Variable configurationVariable) {
        super((Object)configurationVariable);
    }

    public Variable perform(ReadGraph graph) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource result = null;
        Resource model = Variables.getPossibleModel(graph, (Variable)this.parameter);
        if (model == null) {
            return null;
        }
        for (Resource config : graph.getObjects(model, b.ConsistsOf)) {
            if (!graph.isInstanceOf(config, SIMU.Experiment)) continue;
            for (Resource run : graph.getObjects(config, b.ConsistsOf)) {
                if (!graph.isInstanceOf(run, SIMU.Run) || !graph.hasStatement(run, SIMU.IsActive)) continue;
                if (result != null) {
                    return null;
                }
                result = run;
            }
        }
        if (result == null) {
            return null;
        }
        return Variables.switchPossibleContext(graph, (Variable)this.parameter, result);
    }
}

