/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.graph.impl.InputSourceListener;
import org.simantics.browsing.ui.graph.impl.ObservableInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSessionContextInputSource;
import org.simantics.db.Disposable;
import org.simantics.db.management.ISessionContext;

public class WorkbenchSelectionInputSource
implements WorkbenchSessionContextInputSource,
ObservableInputSource,
ISelectionListener,
Disposable {
    protected ISelectionService service;
    protected Object selection;
    protected IWorkbenchPart part;
    protected IWorkbenchPart ownPart;
    protected InputSourceListener listener;

    @Override
    public void init(IWorkbenchSite site, IWorkbenchPart ownPart) {
        this.ownPart = ownPart;
        this.attachToWorkbench();
    }

    protected void attachToWorkbench() {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.service = window.getSelectionService();
        ISelection initialSelection = this.service.getSelection();
        IWorkbenchPart activePart = null;
        if (initialSelection != null && (activePage = window.getActivePage()) != null) {
            activePart = activePage.getActivePart();
        }
        this.selectionChanged(activePart, initialSelection);
        this.service.addPostSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        if (this.service != null) {
            this.service.removePostSelectionListener((ISelectionListener)this);
        }
        this.service = null;
        this.selection = null;
        this.listener = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (Objects.equals(this.ownPart, part)) {
            return;
        }
        Object old = this.selection;
        this.selection = selection;
        this.part = part;
        this.fireIfInputChanged(old, selection);
    }

    protected void fireIfInputChanged(Object oldSelection, Object newSelection) {
        InputSourceListener l = this.listener;
        if (l != null && !Objects.equals(oldSelection, newSelection)) {
            l.inputChanged(this);
        }
    }

    @Override
    public Object get(ISessionContext ctx) {
        Object s = this.selection;
        return s != null ? s : GraphExplorer.EMPTY_INPUT;
    }

    @Override
    public IWorkbenchPart getProvider() {
        return this.part;
    }

    @Override
    public void setListener(InputSourceListener listener) {
        this.listener = listener;
    }
}

