/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.participant.SVGTransfer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.SelectionNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.utils.NodeMapper;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.ui.ErrorLogger;
import org.w3c.dom.Document;

public class CopyAsSVGParticipant
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    protected Selection sel;

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent e) {
        if (e.command.equals((Object)Commands.COPY_AS_SVG)) {
            Set ss = this.sel.getSelection(0);
            CopyAsSVGParticipant.copyAsSVG(this.getContext(), ss);
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void copyAsSVG(ICanvasContext canvasContext, Set<IElement> elements) {
        sg = canvasContext.getSceneGraph();
        clipboardNodeMapper = new NodeMapper();
        selectionRenderingDisabledNodes = new ArrayList<Object>();
        clipboardNode = (SingleElementNode)sg.addNode("svg-clipboard-temp", SingleElementNode.class);
        try {
            for (IElement e : elements) {
                node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                if (node == null) continue;
                for (Object n : NodeUtil.collectNodes((INode)node, RouteGraphNode.class)) {
                    n.setIgnoreSelection(true);
                    selectionRenderingDisabledNodes.add(n);
                }
                for (Object n : NodeUtil.collectNodes((INode)node, SelectionNode.class)) {
                    n.setIgnore(true);
                    selectionRenderingDisabledNodes.add(n);
                }
                for (Object n : NodeUtil.collectNodes((INode)node, TextNode.class)) {
                    n.setShowSelection(false);
                    selectionRenderingDisabledNodes.add(n);
                }
                nodeId = clipboardNodeMapper.add(node);
                delegate = (LinkNode)clipboardNode.addNode(ElementUtils.generateNodeId((IElement)e), LinkNode.class);
                delegate.setDelegateId(nodeId);
            }
            domImpl = GenericDOMImplementation.getDOMImplementation();
            svgNS = "http://www.w3.org/2000/svg";
            document = domImpl.createDocument(svgNS, "svg", null);
            gcDefaults = new SVGGeneratorContext.GraphicContextDefaults();
            ctx = SVGGeneratorContext.createDefault((Document)document);
            hintMap = new HashMap<RenderingHints.Key, Object>();
            hintMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hintMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hintMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hintMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            gcDefaults.setRenderingHints(new RenderingHints(hintMap));
            gcDefaults.setFont(Font.decode(null));
            ctx.setGraphicContextDefaults(gcDefaults);
            svgG2D = new SVGGraphics2D(ctx, false);
            writer = new StringWriter();
            ((IG2DNode)sg.getNode("connection-crossings")).render((Graphics2D)svgG2D);
            clipboardNode.render((Graphics2D)svgG2D);
            root = svgG2D.getRoot();
            bounds = clipboardNode.getBoundsInLocal(true);
            if (bounds != null) {
                root.setAttributeNS(null, "viewBox", String.valueOf(bounds.getMinX()) + " " + bounds.getMinY() + " " + bounds.getWidth() + " " + bounds.getHeight());
                root.setAttributeNS(null, "height", Double.toString(bounds.getHeight()));
                root.setAttributeNS(null, "width", Double.toString(bounds.getWidth()));
            }
            try {
                svgG2D.stream(root, (Writer)writer, false, false);
            }
            catch (SVGGraphics2DIOException e1) {
                ErrorLogger.defaultLogError((String)"Failed to copy the diagram selection as SVG.", (Throwable)e1);
            }
            svgContent = writer.toString().getBytes(StandardCharsets.UTF_8);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Clipboard cb = new Clipboard(Display.getCurrent());
                    cb.setContents((Object[])new byte[][]{svgContent}, new Transfer[]{SVGTransfer.getInstance()});
                }
            });
        }
        finally {
            clipboardNode.removeNodes();
            clipboardNodeMapper.clear();
            clipboardNode.remove();
            ** for (n : selectionRenderingDisabledNodes)
        }
lbl-1000:
        // 1 sources

        {
            if (n instanceof RouteGraphNode) {
                ((RouteGraphNode)n).setIgnoreSelection(false);
                continue;
            }
            if (n instanceof SelectionNode) {
                ((SelectionNode)n).setIgnore(false);
                continue;
            }
            if (!(n instanceof TextNode)) continue;
            ((TextNode)n).setShowSelection(true);
            continue;
        }
lbl79:
        // 1 sources

    }
}

