/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.contribution.Constants;

public enum IssueLabelDecorationRule implements LabelDecorationRule
{
    INSTANCE;

    private static final Decorator[] DECORATORS;

    static {
        Decorator[] decoratorArray = new Decorator[8];
        decoratorArray[1] = new Decorator(true, false, false);
        decoratorArray[2] = new Decorator(false, true, false);
        decoratorArray[3] = new Decorator(true, true, false);
        decoratorArray[4] = new Decorator(false, false, true);
        decoratorArray[5] = new Decorator(true, false, true);
        decoratorArray[6] = new Decorator(false, true, true);
        decoratorArray[7] = new Decorator(true, true, true);
        DECORATORS = decoratorArray;
    }

    public static IssueLabelDecorationRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Variable issue = (Variable)content;
        boolean hidden = false;
        boolean user = false;
        boolean resolved = false;
        Resource issueR = issue.getPossibleRepresents(graph);
        if (issueR != null) {
            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
            hidden = graph.hasStatement(issueR, ISSUE.Hidden);
            user = graph.hasStatement(issueR, ISSUE.UserIssue);
            resolved = graph.hasStatement(issueR, ISSUE.Resolved);
        } else {
            hidden = Boolean.TRUE.equals(issue.getPossiblePropertyValue(graph, "hidden", (Binding)Bindings.BOOLEAN));
        }
        int index = (hidden ? 1 : 0) + (user ? 2 : 0) + (resolved ? 4 : 0);
        return DECORATORS[index];
    }

    private static class Decorator
    extends LabelDecorator.Stub {
        private boolean hidden;
        private boolean user;
        private boolean resolved;

        public Decorator(boolean hidden, boolean user, boolean resolved) {
            this.hidden = hidden;
            this.user = user;
            this.resolved = resolved;
        }

        public <F> F decorateFont(F font, String column, int itemIndex) {
            int style = 0;
            return (F)((style |= this.resolved ? 2 : 0) != 0 ? ((FontDescriptor)font).setStyle(style) : font);
        }

        public <C> C decorateForeground(C color, String column, int itemIndex) {
            if (this.hidden) {
                return (C)Constants.HIDDEN_FG;
            }
            return color;
        }

        public <C> C decorateBackground(C color, String column, int itemIndex) {
            if (this.user) {
                return (C)Constants.USER_BG;
            }
            return color;
        }
    }
}

