/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class SelectionNode
extends G2DNode
implements Decoration {
    private static final long serialVersionUID = -2879575230419873230L;
    public static final transient BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    protected Rectangle2D bounds = null;
    protected Color color = null;
    protected transient Rectangle2D rect;
    protected transient BasicStroke scaledStroke;
    protected transient double previousScaleRecip = Double.NaN;
    protected boolean ignore = false;
    protected int selectionId;

    public int getSelectionId() {
        return this.selectionId;
    }

    public void setIgnore(boolean value) {
        this.ignore = value;
    }

    public void setPaddingFactor(double factor) {
    }

    @INode.SyncField(value={"transform", "bounds", "color"})
    public void init(int selectionId, AffineTransform transform, Rectangle2D bounds, Color color) {
        this.selectionId = selectionId;
        this.transform = transform;
        this.bounds = bounds;
        this.color = color;
    }

    public void init(AffineTransform transform, Rectangle2D bounds, Color color) {
        this.init(0, transform, bounds, color);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.bounds == null) {
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.transform.getDeterminant() == 0.0) {
            return;
        }
        NavigationNode nn = NodeUtil.findNearestParentNode(this, NavigationNode.class);
        double scale = 1.0;
        if (nn != null) {
            scale = GeometryUtils.getScale(nn.getTransform());
        }
        double scaleRecip = 1.0 / scale;
        if (this.scaledStroke == null || scaleRecip != this.previousScaleRecip) {
            this.scaledStroke = GeometryUtils.scaleStroke(SELECTION_STROKE, (float)scaleRecip);
            this.previousScaleRecip = scaleRecip;
        }
        G2DSceneGraph sg = NodeUtil.getRootNode(nn);
        double padding = sg.getGlobalProperty("pickDistance", 0.0) / scale;
        g.setStroke(this.scaledStroke);
        g.setColor(this.color);
        Shape selectionShape = SelectionNode.transformAndExpand(this.bounds, this.transform, padding);
        g.draw(selectionShape);
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        Rectangle2D r = this.transform.createTransformedShape(this.bounds).getBounds2D();
        this.rect.setFrame(r.getMinX() - padding, r.getMinY() - padding, r.getWidth() + 2.0 * padding, r.getHeight() + 2.0 * padding);
    }

    private static Shape transformAndExpand(Rectangle2D r, AffineTransform t, double padding) {
        if (t.getShearX() == 0.0 && t.getShearY() == 0.0 || t.getScaleX() == 0.0 && t.getScaleY() == 0.0) {
            Rectangle2D result = t.createTransformedShape(r).getBounds2D();
            result.setRect(result.getMinX() - padding, result.getMinY() - padding, result.getWidth() + 2.0 * padding, result.getHeight() + 2.0 * padding);
            return result;
        }
        Point2D[] corners = new Point2D.Double[]{new Point2D.Double(r.getMinX(), r.getMinY()), new Point2D.Double(r.getMinX(), r.getMaxY()), new Point2D.Double(r.getMaxX(), r.getMaxY()), new Point2D.Double(r.getMaxX(), r.getMinY())};
        t.transform(corners, 0, corners, 0, 4);
        double det = t.getDeterminant();
        double step = 1.5707963267948966;
        double diagonalPadding = padding * Math.sqrt(2.0);
        Polygon2D poly = new Polygon2D();
        int edge = 0;
        while (edge < 4) {
            int dir;
            int dir2;
            int dir1;
            int p0 = edge % 4;
            int p1 = (edge + 1) % 4;
            int p2 = (edge + 2) % 4;
            double a1 = Math.atan2(((Point2D.Double)corners[p1]).y - ((Point2D.Double)corners[p0]).y, ((Point2D.Double)corners[p1]).x - ((Point2D.Double)corners[p0]).x);
            double a2 = Math.atan2(((Point2D.Double)corners[p2]).y - ((Point2D.Double)corners[p1]).y, ((Point2D.Double)corners[p2]).x - ((Point2D.Double)corners[p1]).x);
            if (det > 0.0) {
                if (a1 < a2) {
                    a1 += Math.PI * 2;
                }
                dir1 = (int)Math.ceil(a1 / step);
                dir2 = (int)Math.floor(a2 / step);
                dir = dir1;
                while (dir > dir2) {
                    poly.addPoint((Point2D)new Point2D.Double(((Point2D.Double)corners[p1]).x + Math.cos(((double)dir + 0.5) * step) * diagonalPadding, ((Point2D.Double)corners[p1]).y + Math.sin(((double)dir + 0.5) * step) * diagonalPadding));
                    --dir;
                }
            } else {
                if (a1 > a2) {
                    a2 += Math.PI * 2;
                }
                dir1 = (int)Math.floor(a1 / step);
                dir2 = (int)Math.ceil(a2 / step);
                dir = dir1;
                while (dir < dir2) {
                    poly.addPoint((Point2D)new Point2D.Double(((Point2D.Double)corners[p1]).x + Math.cos(((double)dir - 0.5) * step) * diagonalPadding, ((Point2D.Double)corners[p1]).y + Math.sin(((double)dir - 0.5) * step) * diagonalPadding));
                    ++dir;
                }
            }
            ++edge;
        }
        return poly;
    }

    public Rectangle2D getRect() {
        return this.rect;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }
}

