/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.SpreadsheetVisitor;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.BinarySearch;
import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetElement;
import org.simantics.spreadsheet.solver.SpreadsheetEngine;
import org.simantics.spreadsheet.solver.SpreadsheetLines;
import org.simantics.spreadsheet.solver.SpreadsheetTypeNode;

public class SpreadsheetLine
implements SpreadsheetElement<SpreadsheetCell, SpreadsheetLines>,
SheetNode {
    private static final long serialVersionUID = -304574098117404663L;
    private final SpreadsheetLines parent;
    public final int row;
    int id;
    public ObjectArrayList<SpreadsheetCell> cells = new ObjectArrayList();

    public SpreadsheetLine(SpreadsheetLines parent, int row) {
        this.parent = parent;
        this.row = row;
        this.id = this.getEngine().getBook().getNewId(this);
    }

    public int getId() {
        return this.id;
    }

    public SpreadsheetEngine getEngine() {
        return this.parent.getEngine();
    }

    public int getRow() {
        return this.row;
    }

    public SpreadsheetLine possibleOffset(int offset) {
        return this.getEngine().getLine(this.row + offset);
    }

    public SpreadsheetCell cellAt(int column) {
        int index = Collections.binarySearch(this.cells, new BinarySearch(column), new Comparator<BinarySearch>(){

            @Override
            public int compare(BinarySearch bs1, BinarySearch bs2) {
                return Integer.compare(bs1.column, bs2.column);
            }
        });
        if (index >= 0) {
            return (SpreadsheetCell)this.cells.get(index);
        }
        return null;
    }

    public String getLinesPath() {
        return "/" + this.parent.getLinesPath() + "/" + this.getName();
    }

    public void forCells(Consumer<SpreadsheetCell> consumer, int min, int max) {
        int i = min;
        while (i < this.cells.size() && i < max) {
            SpreadsheetCell cell = (SpreadsheetCell)this.cells.get(i);
            if (SpreadsheetCell.EMPTY != cell) {
                consumer.accept(cell);
            }
            ++i;
        }
    }

    public List<SpreadsheetCell> getCells(int min, int max) {
        ArrayList<SpreadsheetCell> result = new ArrayList<SpreadsheetCell>();
        this.forCells(cell -> {
            boolean bl = result.add((SpreadsheetCell)cell);
        }, min, max);
        return result;
    }

    @Override
    public String getName() {
        return "Row" + this.row;
    }

    public Map getChildren() {
        String rowName = "" + this.row;
        HashMap<String, SpreadsheetCell> result = new HashMap<String, SpreadsheetCell>();
        int i = 0;
        while (i < this.cells.size()) {
            SpreadsheetCell cell = (SpreadsheetCell)this.cells.get(i);
            if (SpreadsheetCell.EMPTY != cell) {
                String name = String.valueOf(Spreadsheets.columnName(i)) + rowName;
                result.put(name, cell);
            }
            ++i;
        }
        return result;
    }

    public Map getProperties() {
        return Collections.singletonMap("typeURI", new SpreadsheetTypeNode("http://www.simantics.org/Spreadsheet-1.2/Line"));
    }

    Object resolve(String[] parts, int index) {
        if (index == parts.length) {
            return this;
        }
        Range r = Spreadsheets.decodeCellAbsolute(parts[index]);
        return this.cells.get(r.startColumn);
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public String getPath() {
        return String.valueOf(this.parent.getPath()) + "/" + this.getName();
    }

    @Override
    public Optional<SpreadsheetLines> getParent() {
        return Optional.of(this.parent);
    }

    @Override
    public List<SpreadsheetCell> getSpreadsheetChildren() {
        return this.cells;
    }

    @Override
    public void remove(SpreadsheetCell child) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetLine other = (SpreadsheetLine)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return this.row == other.row;
    }
}

