/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.validation;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class ValidateMapping
extends ReadRequest {
    Resource composite;
    Resource diagram;
    ReadGraph g;
    Layer0 b;
    DiagramResource dr;
    StructuralResource2 sr;
    ModelingResources mr;

    public ValidateMapping(Resource composite) {
        this.composite = composite;
    }

    public void run(ReadGraph g) throws DatabaseException {
        this.g = g;
        this.b = Layer0.getInstance((ReadGraph)g);
        this.dr = DiagramResource.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.mr = ModelingResources.getInstance((ReadGraph)g);
        this.diagram = g.getPossibleObject(this.composite, this.mr.CompositeToDiagram);
        System.out.println("------------------------------------------------------------------");
        System.out.println("---- " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.composite));
        if (this.diagram == null) {
            System.out.println("No diagram.");
        } else {
            this.additiveRule();
            this.destructiveRule();
        }
    }

    private void additiveRule() throws DatabaseException {
        for (Resource element : OrderedSetUtils.toList((ReadGraph)this.g, (Resource)this.diagram)) {
            Resource elementType = this.g.getPossibleObject(element, this.b.InstanceOf);
            if (elementType == null) {
                System.out.println("Element " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " has no type.");
                continue;
            }
            Resource componentType = this.g.getPossibleObject(elementType, this.mr.SymbolToComponentType);
            if (componentType != null) {
                this.createComponentRule(element, componentType);
                continue;
            }
            if (this.g.isInstanceOf(element, this.dr.Connection)) {
                this.createNormalConnectionRule(element);
                continue;
            }
            if (!this.g.isInstanceOf(element, this.dr.Flag)) continue;
            this.createFlagRule(element);
        }
    }

    private void createComponentRule(Resource element, Resource componentType) throws DatabaseException {
        Collection components = this.g.getObjects(element, this.mr.ElementToComponent);
        if (components.isEmpty()) {
            System.out.println("Element " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not mapped.");
        } else if (components.size() > 1) {
            System.out.println("Element " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not multiple times.");
        } else {
            for (Resource component : components) {
                if (!this.g.isInstanceOf(component, componentType)) {
                    System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " is not an instance of " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)componentType));
                }
                if (!this.g.hasStatement(component, this.b.PartOf, this.composite)) {
                    System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " is not a part of composite.");
                }
                if (this.g.hasStatement(component, this.mr.Mapped)) continue;
                System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " is not tagged as Mapped.");
            }
        }
    }

    private void createNormalConnectionRule(Resource element) throws DatabaseException {
        Collection connections = this.g.getObjects(element, this.mr.DiagramConnectionToConnection);
        if (connections.isEmpty()) {
            System.out.println("Diagram connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not mapped.");
        } else if (connections.size() > 1) {
            System.out.println("Diagram connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not multiple times.");
        } else {
            for (Resource connection : connections) {
                if (!this.g.isInstanceOf(connection, this.sr.Connection)) {
                    System.out.println("Resource " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)connection) + " is not a connection.");
                }
                if (!this.g.hasStatement(connection, this.mr.Mapped)) {
                    System.out.println("Connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)connection) + " is not tagged as Mapped.");
                }
                for (Resource connector : this.g.getObjects(element, this.sr.IsConnectedTo)) {
                    for (Statement stat : this.g.getStatements(connector, this.sr.Connects)) {
                        Resource component;
                        Resource diagramConnectionRelation = this.g.getInverse(stat.getPredicate());
                        Resource cElement = stat.getObject();
                        Resource connectionRelation = this.g.getPossibleObject(diagramConnectionRelation, this.mr.DiagramConnectionRelationToConnectionRelation);
                        if (connectionRelation == null || (component = this.g.getPossibleObject(cElement, this.mr.ElementToComponent)) == null) continue;
                        Resource connectionRelation2 = this.g.getPossibleObject(diagramConnectionRelation, this.mr.DiagramConnectionRelationToConnectionRelationB);
                        Resource connectionRelation3 = this.g.getPossibleObject(diagramConnectionRelation, this.mr.DiagramConnectionRelationToConnectionRelationC);
                        Resource componentType = this.g.getPossibleObject(diagramConnectionRelation, this.mr.DiagramConnectionRelationToComponentType);
                        if (connectionRelation2 == null || connectionRelation3 == null || componentType == null) {
                            if (this.g.hasStatement(component, connectionRelation, connection)) continue;
                            System.out.println("Missing connection statement " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " . " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)connectionRelation));
                            continue;
                        }
                        Resource component2 = this.g.getPossibleObject(element, this.mr.ElementToComponent);
                        if (component2 == null) {
                            System.out.println("Special connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not mapped.");
                            continue;
                        }
                        if (!this.g.isInstanceOf(component2, componentType)) {
                            System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component2) + " is not an instance of " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)componentType));
                        }
                        if (!this.g.hasStatement(component2, this.b.PartOf, this.composite)) {
                            System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component2) + " is not a part of composite.");
                        }
                        if (!this.g.hasStatement(component2, this.mr.Mapped)) {
                            System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component2) + " is not tagged as Mapped.");
                        }
                        boolean foundConnection2 = false;
                        for (Resource connection2 : this.g.getObjects(component2, connectionRelation2)) {
                            if (!this.g.hasStatement(component, connectionRelation, connection2)) continue;
                            foundConnection2 = true;
                            if (!this.g.isInstanceOf(connection2, this.sr.Connection)) {
                                System.out.println(String.valueOf(NameUtils.getSafeName((ReadGraph)this.g, (Resource)connection2)) + " is not a connection.");
                            }
                            if (this.g.hasStatement(component2, connectionRelation3, connection)) continue;
                            System.out.println("Missing connection point " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component2) + " . " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)connectionRelation3));
                        }
                        if (foundConnection2) continue;
                        System.out.println("Special connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not correctly mapped (missing configuration connection).");
                    }
                }
            }
        }
    }

    private void createFlagRule(Resource element) throws DatabaseException {
        for (Resource connectionJoin : this.g.getObjects(element, this.dr.FlagIsJoinedBy)) {
            for (Resource connector : this.g.getObjects(element, this.sr.IsConnectedTo)) {
                for (Resource diagramConnection : this.g.getObjects(connector, this.sr.Connects)) {
                    for (Resource connection : this.g.getObjects(diagramConnection, this.mr.DiagramConnectionToConnection)) {
                        if (!this.g.hasStatement(connectionJoin, this.sr.Joins, connection)) {
                            System.out.println("Joins-relation of flag " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)element) + " is not mapped.");
                        }
                        if (this.g.hasStatement(this.composite, this.sr.HasConnectionJoin, connectionJoin)) continue;
                        System.out.println("Connection join is not attached to the composite.");
                    }
                }
            }
        }
    }

    private void destructiveRule() throws DatabaseException {
        for (Resource component : this.g.getObjects(this.composite, this.b.ConsistsOf)) {
            if (!this.g.hasStatement(component, this.mr.Mapped)) continue;
            Collection elements = this.g.getObjects(component, this.mr.ComponentToElement);
            if (elements.isEmpty()) {
                System.out.println("Component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " does not have corresponding element (but is tagged Mapped).");
            }
            for (Resource element : elements) {
                if (!OrderedSetUtils.contains((ReadGraph)this.g, (Resource)this.diagram, (Resource)element)) {
                    System.out.println("Element corresponding to component " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)component) + " is not included in the diagram.");
                    continue;
                }
                for (Statement stat : this.g.getStatements(component, this.sr.IsConnectedTo)) {
                    Resource connection = stat.getObject();
                    if (!this.g.hasStatement(connection, this.mr.Mapped) || this.g.hasStatement(connection, this.mr.ConnectionMapsTo)) continue;
                    System.out.println("Connection " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)connection) + " does not have a correspondence in diagram (but is tagged Mapped).");
                }
            }
        }
    }
}

