/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.map.Tuple;

public class StructuralModelChanges {
    private static final boolean TRACE_REFERENCE_FIXES = false;
    private Resource model;
    private THashMap<Resource, Resource> moves = new THashMap();
    private THashMap<Resource, String> renames = new THashMap();

    public StructuralModelChanges(Resource model) {
        this.model = model;
    }

    public void move(Resource component, Resource target) {
        this.moves.put((Object)component, (Object)target);
    }

    public void rename(Resource component, String newName) {
        this.renames.put((Object)component, (Object)newName);
    }

    public void apply(WriteGraph graph) throws DatabaseException {
        Resource component;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        try {
            this.loadAllReferences(graph, this.model, (Set<Resource>)new THashSet());
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
        for (Map.Entry entry : this.moves.entrySet()) {
            component = (Resource)entry.getKey();
            Resource target = (Resource)entry.getValue();
            for (Resource source : graph.getObjects(component, L0.PartOf)) {
                graph.deny(component, L0.PartOf, source);
            }
            graph.claim(component, L0.PartOf, L0.ConsistsOf, target);
        }
        for (Map.Entry entry : this.renames.entrySet()) {
            component = (Resource)entry.getKey();
            Resource container = graph.getSingleObject(component, L0.PartOf);
            String freshName = NameUtils.findFreshName((ReadGraph)graph, (String)((String)entry.getValue()), (Resource)container, (Resource)L0.ConsistsOf, (String)"%s%d");
            graph.claimLiteral(component, L0.HasName, (Object)freshName);
        }
    }

    private void loadAllReferences(WriteGraph graph, Resource root, Set<Resource> visited) throws DatabaseException, AdaptException {
        if (!visited.add(root)) {
            return;
        }
    }

    static class Info
    extends Tuple {
        public Info(Resource component, String rvi) {
            super(new Object[]{component, rvi});
        }

        public Resource getComponent() {
            return (Resource)this.getField(0);
        }

        public String getRvi() {
            return (String)this.getField(1);
        }
    }

    static class Reference
    extends Tuple {
        public Reference(Resource referee, String rvi) {
            super(new Object[]{referee, rvi});
        }

        public Resource getReferee() {
            return (Resource)this.getField(0);
        }

        public String getRVI() {
            return (String)this.getField(1);
        }
    }
}

