/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.Map;
import java.util.TreeMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;

public final class ValueTable
extends Table<byte[]> {
    private TreeMap<Integer, Integer> valueMap = new TreeMap();
    private int VALUE_SIZE = 0;
    private int VALUE_OFFSET = 0;

    public ValueTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase);
    }

    public ValueTable(TableSizeListener sizeListener, int[] header, int headerBase, byte[] bytes) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase, (Object)bytes);
    }

    void getValue(int valueIndex, byte[] to, int start, int size) {
        this.getCopy(valueIndex, to, start, size);
    }

    void getString(int valueIndex, char[] to, int start, int size) {
        byte[] bs = (byte[])this.table;
        start += valueIndex + this.offset + 1;
        int i = 0;
        while (i < size) {
            to[i] = (char)bs[start++];
            ++i;
        }
    }

    void setValue(int valueIndex, byte[] value, int length) {
        this.setCopy(valueIndex, length, value, 0);
    }

    int createValue(byte[] value, int voffset, int vsize) {
        int valueIndex = this.createNewElement(vsize);
        this.setCopy(valueIndex, vsize, value, voffset);
        return valueIndex;
    }

    int createValue(byte[] value) {
        int valueIndex = this.createNewElement(value.length);
        this.setCopy(valueIndex, value.length, value, 0);
        return valueIndex;
    }

    void removeValue(int valueIndex, int size) {
        this.deleteOldElement(valueIndex, size);
    }

    boolean isEqual(int valueIndex, byte[] value) {
        return this.isEqual(valueIndex, value, 0, value.length);
    }

    public void checkValueInit() throws DatabaseException {
        this.valueMap.clear();
        int s = this.getTableSize();
        int c = this.getTableCapacity();
        if (s < 0 || s > c) {
            throw new ValidationException("Illegal value table size=" + s + " cap=" + c);
        }
        this.VALUE_SIZE = s;
        this.VALUE_OFFSET = this.getTableBase() - 1;
    }

    public void checkValue(int capacity, int index) throws DatabaseException {
        if (capacity == 0 && index == 0) {
            return;
        }
        if (capacity < 1) {
            throw new ValidationException("Illegal resource value capacity=" + capacity);
        }
        if (index < 1) {
            throw new ValidationException("Illegal resource value index=" + index);
        }
        if (this.VALUE_SIZE < capacity + index + this.VALUE_OFFSET) {
            throw new ValidationException("Illegal resource value c=" + capacity + " i=" + index + " ts=" + this.VALUE_SIZE + " off=" + this.VALUE_OFFSET);
        }
        Integer valueCap = this.valueMap.get(index);
        if (valueCap == null) {
            this.valueMap.put(index, capacity);
        } else if (capacity > valueCap) {
            this.valueMap.put(index, capacity);
        } else {
            this.valueMap.put(index, valueCap);
        }
    }

    public void checkValueFini() throws DatabaseException {
        int last = 0;
        for (Map.Entry<Integer, Integer> e : this.valueMap.entrySet()) {
            int i = e.getKey();
            int c = e.getValue();
            int cur = this.VALUE_OFFSET + i;
            if (last > cur) {
                throw new ValidationException("Index error with resource value c=" + c + " i=" + i + " ts=" + this.VALUE_SIZE + " off=" + this.VALUE_OFFSET);
            }
            last = cur + c;
        }
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}

