/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.impl.PrimeFinder;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.IntHashTrait;

public class IntHash
extends IntHashTrait {
    static final int HeaderSize = 4;
    private static final int REAL_SIZE = -4;
    private static final int USED_SIZE = -3;
    private static final int FREE_SIZE = -2;
    private static final int MAX_SIZE = -1;

    public static int getRealSize(int[] table, int hashBase) {
        return table[hashBase + -4];
    }

    private static void setRealSize(int[] table, int hashBase, int realSize) {
        assert (realSize > 0);
        table[hashBase + -4] = realSize;
    }

    public static int getUsedSize(int[] table, int hashBase) {
        return table[hashBase + -3];
    }

    static void setUsedSize(int[] table, int hashBase, int usedSize) {
        assert (usedSize >= 0);
        table[hashBase + -3] = usedSize;
    }

    static int decUsedSize(int[] table, int hashBase) {
        int n = hashBase + -3;
        table[n] = table[n] - 1;
        return table[hashBase + -3];
    }

    static int incUsedSize(int[] table, int hashBase) {
        int n = hashBase + -3;
        table[n] = table[n] + 1;
        return table[hashBase + -3];
    }

    static void setUsedAndRealSize(int[] table, int hashBase, int used, int real) {
        IntHash.setUsedSize(table, hashBase, used);
        IntHash.setRealSize(table, hashBase, real);
    }

    static int getFreeSize(int[] table, int hashBase) {
        return table[hashBase + -2];
    }

    static void setFreeSize(int[] table, int hashBase, int freeSize) {
        assert (freeSize >= 0);
        table[hashBase + -2] = freeSize;
    }

    static void decFreeSize(int[] table, int hashBase) {
        int n = hashBase + -2;
        table[n] = table[n] - 1;
    }

    static int getMaxSize(int[] table, int hashBase) {
        return table[hashBase + -1];
    }

    static void setMaxSize(int[] table, int hashBase, int maxSize) {
        assert (maxSize > 0);
        table[hashBase + -1] = maxSize;
    }

    static void setMaxAndFreeSize(int[] table, int hashBase, int max, int free) {
        IntHash.setMaxSize(table, hashBase, max);
        IntHash.setFreeSize(table, hashBase, free);
    }

    public static int getAllocatedSize(int[] table, int hashBase) {
        return IntHash.getRealSize(table, hashBase) + 4;
    }

    public static int create(int[] ints, IntAllocatorI allocator) {
        assert (ints.length > 0);
        int desiredSize = ints.length;
        int hashBase = IntHash.create(desiredSize, allocator);
        int i = 0;
        while (i < desiredSize) {
            hashBase = IntHash.add(allocator.getTable(), hashBase, ints[i], allocator);
            ++i;
        }
        return hashBase;
    }

    public static int create(int desiredSize, IntAllocatorI allocator) {
        int capacity = PrimeFinder.nextPrime((int)((desiredSize << 1) + 1));
        int hashBase = allocator.allocate(capacity + 4) + 4;
        int[] table = allocator.getTable();
        IntHash.setUsedAndRealSize(table, hashBase, 0, capacity);
        IntHash.setMaxAndFreeSize(table, hashBase, capacity >> 1, capacity);
        return hashBase;
    }

    public static int add(int[] table, int hashBase, int a, IntAllocatorI allocator) {
        int index = IntHash.insertionIndex(table, hashBase, a);
        if (index < 0) {
            return 0;
        }
        int previousState = table[index];
        assert (IntHash.isFull(a));
        table[index] = a;
        return IntHash.postInsertHook(table, hashBase, IntHash.isFree(previousState), allocator);
    }

    public static boolean remove(int[] table, int hashBase, int a) {
        int index = IntHash.index(table, hashBase, a);
        if (index >= 0) {
            table[index] = IntHash.setRemoved();
            IntHash.decUsedSize(table, hashBase);
            return true;
        }
        return false;
    }

    public static int removeLast(int[] table, int hashBase) throws DatabaseException {
        int size = IntHash.getUsedSize(table, hashBase);
        if (size != 1) {
            throw new DatabaseException("Illegal call of IntHash.removeLast.");
        }
        int capacity = IntHash.getRealSize(table, hashBase);
        int count = 0;
        int i = capacity + hashBase;
        while (count < size && i-- > hashBase) {
            int o = table[i];
            if (!IntHash.isFull(o)) continue;
            table[i] = IntHash.setRemoved();
            IntHash.decUsedSize(table, hashBase);
            return o;
        }
        throw new DatabaseException("IntHash.removeLast call failed.");
    }

    public static boolean contains(int[] table, int hashBase, int a) {
        return IntHash.index(table, hashBase, a) >= 0;
    }

    public static boolean isEmpty(int[] table, int hashBase) {
        return IntHash.getUsedSize(table, hashBase) == 0;
    }

    public static void clear(int[] table, int hashBase) {
        int capacity;
        int[] set = table;
        int free = IntHash.setFree();
        int i = capacity = IntHash.getRealSize(table, hashBase);
        while (i-- > 0) {
            set[hashBase + i] = free;
        }
        IntHash.setUsedSize(table, hashBase, 0);
        IntHash.setFreeSize(table, hashBase, capacity);
    }

    public static boolean ensureSize(int[] table, int hashBase, int desiredSize, IntAllocatorI allocator) {
        int size = IntHash.getUsedSize(table, hashBase);
        if (desiredSize > IntHash.getMaxSize(table, hashBase) - size) {
            int newCapacity = (desiredSize + size << 1) + 1;
            IntHash.rehash(table, hashBase, PrimeFinder.nextPrime((int)newCapacity), allocator);
            return true;
        }
        return false;
    }

    public static void compact(int[] table, int hashBase, IntAllocatorI allocator) {
        IntHash.rehash(table, hashBase, PrimeFinder.nextPrime((int)((IntHash.getUsedSize(table, hashBase) << 1) + 1)), allocator);
    }

    static void foreachInt(ReadGraphImpl graph, int[] table, int base, SyncMultiProcedure<Resource> procedure, Modifier modifier) throws DatabaseException {
        int capacity = IntHash.getRealSize(table, base);
        int size = IntHash.getUsedSize(table, base);
        int count = 0;
        int i = capacity + base;
        while (count < size && i-- > base) {
            int o = table[i];
            if (!IntHash.isFull(o)) continue;
            int actual = modifier.execute(o);
            procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), actual));
            ++count;
        }
        procedure.finished((ReadGraph)graph);
        assert (size == count);
    }

    static <C> void foreachInt(ReadGraphImpl graph, int[] table, int base, C context, SyncContextMultiProcedure<C, Resource> procedure, Modifier modifier) throws DatabaseException {
        int capacity = IntHash.getRealSize(table, base);
        int size = IntHash.getUsedSize(table, base);
        int count = 0;
        int i = capacity + base;
        while (count < size && i-- > base) {
            int o = table[i];
            if (!IntHash.isFull(o)) continue;
            int actual = modifier.execute(o);
            procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), actual));
            ++count;
        }
        procedure.finished((ReadGraph)graph, context);
        assert (size == count);
    }

    static int getSingleInt(int[] table, int base, Modifier modifier) throws DatabaseException {
        int result = 0;
        int capacity = IntHash.getRealSize(table, base);
        int size = IntHash.getUsedSize(table, base);
        int count = 0;
        int i = capacity + base;
        while (count < size && i-- > base) {
            int o = table[i];
            if (!IntHash.isFull(o)) continue;
            int value = modifier != null ? modifier.execute(o) : o;
            result = result == 0 ? value : -1;
            if (size == ++count) break;
        }
        assert (size == count);
        return result;
    }

    static <Context> boolean foreachInt(int[] table, int base, ClusterI.ObjectProcedure<Context> procedure, Context context, Modifier modifier) throws DatabaseException {
        int capacity = IntHash.getRealSize(table, base);
        int size = IntHash.getUsedSize(table, base);
        int count = 0;
        int i = capacity + base;
        while (count < size && i-- > base) {
            int o = table[i];
            if (!IntHash.isFull(o)) continue;
            int value = modifier != null ? modifier.execute(o) : o;
            if (procedure.execute(context, value)) {
                return true;
            }
            if (size != ++count) continue;
            return false;
        }
        assert (size == count);
        return false;
    }

    private static final int rehash(int[] oldtable, int oldHashBase, int newCapacity, IntAllocatorI allocator) {
        assert (PrimeFinder.nextPrime((int)newCapacity) == newCapacity);
        int oldCapacity = IntHash.getRealSize(oldtable, oldHashBase);
        int oldSize = IntHash.getUsedSize(oldtable, oldHashBase);
        int newHashBase = allocator.allocate(newCapacity + 4) + 4;
        int[] newtable = allocator.getTable();
        IntHash.setUsedAndRealSize(newtable, newHashBase, oldSize, newCapacity);
        IntHash.setMaxAndFreeSize(newtable, newHashBase, newCapacity >> 1, newCapacity - oldSize);
        int i = oldCapacity + oldHashBase;
        while (i-- > oldHashBase) {
            int o = oldtable[i];
            if (!IntHash.isFull(o)) continue;
            int index = IntHash.insertionIndex(newtable, newHashBase, o);
            newtable[index] = o;
        }
        return newHashBase;
    }

    private static final int postInsertHook(int[] table, int hashBase, boolean usedFreeSlot, IntAllocatorI allocator) {
        if (usedFreeSlot) {
            IntHash.decFreeSize(table, hashBase);
        }
        if (IntHash.incUsedSize(table, hashBase) > IntHash.getMaxSize(table, hashBase) || IntHash.getFreeSize(table, hashBase) == 0) {
            int newCapacity = IntHash.getUsedSize(table, hashBase) > IntHash.getMaxSize(table, hashBase) ? PrimeFinder.nextPrime((int)(IntHash.getRealSize(table, hashBase) << 1)) : IntHash.getRealSize(table, hashBase);
            return IntHash.rehash(table, hashBase, newCapacity, allocator);
        }
        return hashBase;
    }

    private static int index(int[] table, int hashBase, int a) {
        int[] set = table;
        int length = IntHash.getRealSize(table, hashBase);
        int hash = IntHash.computeHashCode(a);
        int index = hash % length;
        int hashIndex = hashBase + index;
        if (!IntHash.isFree(set[hashIndex]) && (IntHash.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!IntHash.isFree(set[hashIndex = hashBase + index]) && (IntHash.isRemoved(set[hashIndex]) || set[hashIndex] != a));
        }
        return IntHash.isFree(set[hashIndex]) ? -1 : hashIndex;
    }

    private static final int insertionIndex(int[] table, int hashBase, int a) {
        int[] set = table;
        int length = IntHash.getRealSize(table, hashBase);
        int hash = IntHash.computeHashCode(a);
        int index = hash % length;
        assert (hashBase != 0);
        int hashIndex = hashBase + index;
        if (IntHash.isFree(set[hashIndex])) {
            return hashIndex;
        }
        if (IntHash.isFull(set[hashIndex]) && set[hashIndex] == a) {
            return -hashIndex;
        }
        int probe = 1 + hash % (length - 2);
        if (!IntHash.isRemoved(set[hashIndex])) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (IntHash.isFull(set[hashIndex = hashBase + index]) && set[hashIndex] != a);
        }
        if (IntHash.isRemoved(set[hashIndex])) {
            int firstRemoved = hashIndex;
            while (!IntHash.isFree(set[hashIndex]) && (IntHash.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                hashIndex = hashBase + index;
            }
            return IntHash.isFull(set[hashIndex]) ? -hashIndex : firstRemoved;
        }
        return IntHash.isFull(set[hashIndex]) ? -hashIndex : hashIndex;
    }

    private static final int computeHashCode(int aKey) {
        int hash = aKey * 31;
        return hash & Integer.MAX_VALUE;
    }
}

