/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.Activator;
import fi.vtt.simantics.procore.internal.SerialisationSupportImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.ServerInformation;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.FileUtils;

public class VirtualGraphServerSupportImpl
implements VirtualGraphSupport,
VirtualGraphServerSupport {
    private static final boolean DEBUG = false;
    private final SessionImplSocket session;
    public final File virtualGraphStoragePath;
    public String dbString = null;
    public TIntHashSet virtuals = new TIntHashSet();
    public final CopyOnWriteArrayList<TransientGraph> providers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TransientGraph> workspaceProviders = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TransientGraph> memoryProviders = new CopyOnWriteArrayList();
    public AtomicInteger virtualId;
    private boolean hasVirtuals = false;

    public VirtualGraphServerSupportImpl(SessionImplSocket session, File path) {
        this.session = session;
        this.virtualGraphStoragePath = path;
    }

    void connect(String dbString) throws Exception {
        File file;
        this.virtualId = new AtomicInteger(-2);
        this.dbString = dbString;
        XSupport support = this.session.getService(XSupport.class);
        if (support.rolledback()) {
            File[] fileArray = this.virtualGraphStoragePath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (!file.delete()) {
                    throw new IOException("Could not delete file " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
        if ((file = new File(this.virtualGraphStoragePath, "virtualGraphs." + dbString + ".dat")).exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                ObjectInputStream os = new ObjectInputStream(stream);
                this.virtualId = new AtomicInteger(os.readInt());
                os.close();
                ((InputStream)stream).close();
                this.hasVirtuals = true;
                String databaseId = this.session.getService(ServerInformation.class).getDatabaseId();
                final String matcher = ".W." + databaseId + ".vg.";
                File[] fileArray = this.virtualGraphStoragePath.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean matches = name.contains(matcher);
                        return matches;
                    }
                });
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File virtualGraph = fileArray[n3];
                    String name = virtualGraph.getName();
                    String[] parts = name.split("\\x2E", 2);
                    this.getWorkspacePersistent(parts[0]);
                    ++n3;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveVirtualGraphState(SessionImplSocket session) {
        if (!this.hasVirtuals) {
            return;
        }
        try {
            String databaseId = session.getService(ServerInformation.class).getDatabaseId();
            String serverId = session.getService(ServerInformation.class).getServerId();
            File file = new File(this.virtualGraphStoragePath, "virtualGraphs." + databaseId + "." + serverId + ".dat");
            FileOutputStream stream = new FileOutputStream(file);
            ObjectOutputStream os = new ObjectOutputStream(stream);
            os.writeInt(this.virtualId.get());
            os.flush();
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disposeVirtualGraphs() {
        if (!this.hasVirtuals) {
            return;
        }
        this.saveVirtualGraphState(this.session);
        for (TransientGraph graph : this.workspaceProviders) {
            graph.dispose();
        }
        TransientGraph.processUndeleted();
    }

    public void saveVirtualGraphs() {
        if (!this.hasVirtuals) {
            return;
        }
        this.saveVirtualGraphState(this.session);
        for (TransientGraph graph : this.workspaceProviders) {
            graph.save();
        }
    }

    public void saveAll() {
        this.saveVirtualGraphs();
    }

    public VirtualGraph getMemoryPersistent(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument cannot be null!");
        }
        for (TransientGraph graph : this.memoryProviders) {
            if (!identifier.equals(graph.getIdentifier())) continue;
            return graph;
        }
        String databaseId = this.session.getService(ServerInformation.class).getDatabaseId();
        VirtualGraphServerSupport vgss = this.session.getService(VirtualGraphServerSupport.class);
        TransientGraph result = TransientGraph.memoryPersistent((SerialisationSupport)new SerialisationSupportImpl(this.session), (VirtualGraphServerSupport)vgss, (ResourceSupport)this.session.resourceSupport, (AsyncRequestProcessor)this.session, (String)databaseId, (String)identifier);
        this.memoryProviders.add(result);
        this.providers.add(result);
        return result;
    }

    private TransientGraph createWorkspacePersistentInternal(String identifier) {
        String databaseId = this.session.getService(ServerInformation.class).getDatabaseId();
        VirtualGraphServerSupport vgss = this.session.getService(VirtualGraphServerSupport.class);
        try {
            return TransientGraph.workspacePersistent((SerialisationSupport)new SerialisationSupportImpl(this.session), (VirtualGraphServerSupport)vgss, (ResourceSupport)this.session.resourceSupport, (AsyncRequestProcessor)this.session, (String)databaseId, (String)identifier);
        }
        catch (Exception e) {
            Activator.log((IStatus)new Status(2, "org.simantics.db.procore", "Failed to restore contents of previous virtual graph with identifier '" + identifier + "'. Resetting its contents to empty. See exception for problem details.", (Throwable)e));
            return TransientGraph.memoryPersistent((SerialisationSupport)new SerialisationSupportImpl(this.session), (VirtualGraphServerSupport)vgss, (ResourceSupport)this.session.resourceSupport, (AsyncRequestProcessor)this.session, (String)databaseId, (String)identifier);
        }
    }

    public VirtualGraph getWorkspacePersistent(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument cannot be null!");
        }
        for (TransientGraph graph : this.workspaceProviders) {
            if (!identifier.equals(graph.getIdentifier())) continue;
            return graph;
        }
        TransientGraph result = this.createWorkspacePersistentInternal(identifier);
        this.workspaceProviders.add(result);
        this.providers.add(result);
        this.hasVirtuals = true;
        return result;
    }

    public boolean discard(VirtualGraph provider) {
        if (!(provider instanceof TransientGraph)) {
            return false;
        }
        if (!this.providers.remove(provider)) {
            return false;
        }
        TransientGraph tg = (TransientGraph)provider;
        if (this.workspaceProviders.remove(provider)) {
            tg.dispose();
            tg.delete();
        } else if (this.memoryProviders.remove(provider)) {
            tg.dispose();
            tg.delete();
        }
        return true;
    }

    public Resource getPersistentResource(WriteOnlyGraph graph, Resource resource, Map<Resource, Resource> creation) throws DatabaseException {
        if (resource.isPersistent()) {
            return resource;
        }
        Resource result = creation.get(resource);
        if (result == null) {
            result = graph.newResource();
            creation.put(resource, result);
        }
        return result;
    }

    public boolean integrate(WriteOnlyGraph graph, VirtualGraph provider) throws DatabaseException {
        if (!(provider instanceof TransientGraph)) {
            return false;
        }
        if (!this.providers.remove(provider)) {
            return false;
        }
        this.workspaceProviders.remove(provider);
        this.memoryProviders.remove(provider);
        TransferableGraphSupport tgSupport = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        TransientGraph tg = (TransientGraph)provider;
        HashMap<Resource, Resource> creation = new HashMap<Resource, Resource>();
        for (Statement stm : tg.listStatements()) {
            Resource subject = this.getPersistentResource(graph, stm.getSubject(), creation);
            Resource predicate = this.getPersistentResource(graph, stm.getPredicate(), creation);
            Resource object = this.getPersistentResource(graph, stm.getObject(), creation);
            graph.claim(subject, predicate, null, object);
        }
        for (Resource r : tg.listValues()) {
            byte[] value = tg.getValue(((ResourceImpl)r).id);
            tgSupport.setValue(graph, this.getPersistentResource(graph, r, creation), null, value);
        }
        this.discard(provider);
        return true;
    }

    public Collection<TransientGraph> getVirtualGraphs(int subject) {
        if (subject < 0 || this.virtuals.contains(subject)) {
            return this.providers;
        }
        return null;
    }

    public void removeVirtual(int id) {
        this.virtuals.remove(id);
    }

    public void addVirtual(int id) {
        assert (id > 0);
        this.virtuals.add(id);
        Object cluster = this.session.clusterTable.getClusterByResourceKey(id);
        cluster.markVirtual();
    }

    public int createVirtual() {
        return this.virtualId.decrementAndGet();
    }

    public File storagePath() {
        return this.virtualGraphStoragePath;
    }

    public Collection<Statement> listStatements(VirtualGraph graph_) {
        TransientGraph graph = (TransientGraph)graph_;
        return graph.listStatements();
    }

    public Collection<Resource> listValues(VirtualGraph graph_) {
        TransientGraph graph = (TransientGraph)graph_;
        return graph.listValues();
    }

    public Collection<VirtualGraph> listGraphs() {
        ArrayList<VirtualGraph> result = new ArrayList<VirtualGraph>();
        result.addAll(this.memoryProviders);
        result.addAll(this.workspaceProviders);
        return result;
    }

    public String report(final File file) {
        this.session.asyncRequest(new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                SerialisationSupport ss = VirtualGraphServerSupportImpl.this.session.getService(SerialisationSupport.class);
                StringBuilder b = new StringBuilder();
                try {
                    for (VirtualGraph vg : VirtualGraphServerSupportImpl.this.listGraphs()) {
                        TransientGraph tg = (TransientGraph)vg;
                        if (VirtualGraph.Persistency.MEMORY == tg.getPersistency()) {
                            b.append("Memory persistent virtual graph '" + tg.getIdentifier() + "'\n");
                        }
                        if (VirtualGraph.Persistency.WORKSPACE == tg.getPersistency()) {
                            b.append("Workspace persistent virtual graph '" + tg.getIdentifier() + "'\n");
                        }
                        for (Statement stm : VirtualGraphServerSupportImpl.this.listStatements((VirtualGraph)tg)) {
                            int s = ss.getTransientId(stm.getSubject());
                            int p = ss.getTransientId(stm.getPredicate());
                            int o = ss.getTransientId(stm.getObject());
                            String sName = NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject());
                            String pName = NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate());
                            String oName = NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject());
                            b.append(" S '" + sName + "' '" + pName + "' '" + oName + "' " + s + " " + p + " " + o + "\n");
                        }
                        for (Resource r : VirtualGraphServerSupportImpl.this.listValues((VirtualGraph)tg)) {
                            String sName = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                            Object value = graph.getPossibleValue(r);
                            b.append(" V '" + sName + "' '" + value + "'\n");
                        }
                    }
                    FileUtils.writeFile((File)file, (byte[])b.toString().getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "ERROR";
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return "ERROR";
                }
                return "OK";
            }
        });
        return "OK";
    }

    public VirtualGraph getGraph(ReadGraph graph, Resource subject, Resource predicate, Resource object) throws DatabaseException {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.getProvider(subject, predicate, object);
    }

    public VirtualGraph getGraph(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.getProvider(subject, predicate);
    }

    public VirtualGraph getGraph(ReadGraph graph, Resource subject) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.hasStatement(subject, L0.InstanceOf)) {
            return this.getGraph(graph, subject, L0.InstanceOf);
        }
        if (graph.hasStatement(subject, L0.Inherits)) {
            return this.getGraph(graph, subject, L0.Inherits);
        }
        if (graph.hasStatement(subject, L0.SubrelationOf)) {
            return this.getGraph(graph, subject, L0.SubrelationOf);
        }
        throw new DatabaseException("Resource is invalid, should have a statement with either L0.InstanceOf, L0.Inherits or L0.SubrelationOf " + subject);
    }
}

