/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.fileimport;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.fileimport.SimanticsResourceFileImport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.db.SCLFunctions;
import org.simantics.spreadsheet.graph.ExcelImport;

public class ExcelFileImport
extends SimanticsResourceFileImport {
    private static final Map<String, String> ALLOWED_EXTENSIONS = new HashMap<String, String>(2);

    static {
        ALLOWED_EXTENSIONS.put("*.xls", "Excel file");
        ALLOWED_EXTENSIONS.put("*.xlsx", "Excel file");
        ALLOWED_EXTENSIONS.put("*.xlsm", "Excel file");
    }

    public Optional<Resource> perform(Resource possibleSelection, Path file) throws Exception {
        if (possibleSelection != null) {
            Layer0 L0 = Layer0.getInstance((RequestProcessor)Simantics.getSession());
            Resource library = (Resource)SCLFunctions.evaluateDB((String)"Simantics/SharedOntologies", (String)"createSharedOntology", (Object[])new Object[]{"http://" + file.toFile().getName() + "@A", L0.SharedOntology});
            return Optional.ofNullable(ExcelImport.importBookR((Resource)library, (File)file.toFile()));
        }
        throw new NullPointerException("No selection provided - Cannot import book");
    }

    public Map<String, String> allowedExtensionsWithFilters() {
        return ALLOWED_EXTENSIONS;
    }

    public Resource defaultParentResource() {
        return null;
    }
}

