/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.impl;

import java.util.Map;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementAdapter;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintStack;
import org.simantics.utils.datastructures.hints.IHintContext;

public class MutatedElement
extends HintStack
implements IElement {
    IDiagram diagram;
    IElement orig;
    ElementClass origClass;
    HintContext mutations;

    public MutatedElement(IElement orig) {
        if (orig == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.orig = orig;
        this.origClass = orig.getElementClass();
        this.addHintContext(orig, 0);
    }

    @Override
    public void addedToDiagram(IDiagram ctx) {
        this.diagram = ctx;
    }

    @Override
    public IDiagram getDiagram() {
        assert (this.diagram != null);
        return this.diagram;
    }

    @Override
    public IDiagram peekDiagram() {
        return this.diagram;
    }

    @Override
    public ElementClass getElementClass() {
        return this.origClass;
    }

    public synchronized void clearWithoutNotification() {
        if (this.mutations != null) {
            this.mutations.clearWithoutNotification();
        }
    }

    public synchronized <E> E removeHint(IHintContext.Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (this.mutations == null) {
            return null;
        }
        Object result = this.mutations.removeHint(key);
        if (this.mutations.size() == 0) {
            this.removeHintContext((IHintContext)this.mutations);
            this.mutations = null;
        }
        return (E)result;
    }

    public synchronized void setHint(IHintContext.Key key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!key.isValueAccepted(value)) {
            throw new RuntimeException("Value \"" + value + "\" is not accepted with key " + key.getClass().getName());
        }
        if (this.mutations == null) {
            this.mutations = new HintContext();
            this.addHintContext((IHintContext)this.mutations, 10);
        }
        this.mutations.setHint(key, value);
    }

    public synchronized void setHints(Map<IHintContext.Key, Object> hints) {
        if (this.mutations == null) {
            this.mutations = new HintContext();
            this.addHintContext((IHintContext)this.mutations, 10);
        }
        this.mutations.setHints(hints);
    }

    @Override
    public void destroy() {
        for (LifeCycle lc : this.getElementClass().getItemsByClass(LifeCycle.class)) {
            lc.onElementDestroyed(this);
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.mutations != null) {
            this.removeHintContext((IHintContext)this.mutations);
        }
        this.removeHintContext(this.orig);
        this.orig = null;
        this.origClass = null;
        this.mutations = null;
    }

    public Object getAdapter(Class adapter) {
        for (ElementAdapter ea : this.getElementClass().getItemsByClass(ElementAdapter.class)) {
            Object result = ea.adapt(this, adapter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int hashCode() {
        return this.orig != null ? this.orig.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.orig == null ? false : this.orig.equals(obj);
    }

    public String toString() {
        return "MutatedElement[" + this.orig + " " + this.origClass + "]";
    }
}

