/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.lang.reflect.Field;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DiagramHandler;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class AbstractDiagramParticipant
extends AbstractCanvasParticipant {
    public IDiagram diagram;
    public DiagramClass clazz;
    protected DependencyReflection.ReferenceDefinition[] handlerDefs = DependencyReflection.getDependencies(this, DependencyReflection.ReferenceType.DiagramHandler);
    boolean handlerDepsSatisfied = true;

    @HintReflection.HintListener(Class=DiagramHints.class, Field="KEY_DIAGRAM")
    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        this._setDiagram((IDiagram)newValue);
    }

    @HintReflection.HintListener(Class=DiagramHints.class, Field="KEY_DIAGRAM")
    public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        this._setDiagram(null);
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this._setDiagram((IDiagram)ctx.getHintStack().getHint(DiagramHints.KEY_DIAGRAM));
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this._setDiagram(null);
        super.removedFromContext(ctx);
    }

    @Override
    public void assertDependencies() {
        super.assertDependencies();
        assert (this.diagram != null);
    }

    private void _setDiagram(IDiagram d) {
        IDiagram oldDiagram = this.diagram;
        this.diagram = d;
        this.clazz = d != null ? d.getDiagramClass() : null;
        if (this.clazz != null) {
            try {
                for (DiagramHandler h : this.clazz.getAll()) {
                    Class<?> c = h.getClass();
                    DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.handlerDefs;
                    int n = this.handlerDefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DependencyReflection.ReferenceDefinition def = referenceDefinitionArray[n2];
                        Class<?> defClass = def.requirement;
                        if (defClass.isAssignableFrom(c)) {
                            Field f = def.field;
                            f.set(this, h);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.handlerDepsSatisfied = this.checkHandlerDependencies();
        } else {
            try {
                DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.handlerDefs;
                int n = this.handlerDefs.length;
                int n3 = 0;
                while (n3 < n) {
                    DependencyReflection.ReferenceDefinition def = referenceDefinitionArray[n3];
                    Field f = def.field;
                    f.set(this, null);
                    ++n3;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.handlerDepsSatisfied = true;
        }
        this.onDiagramSet(this.diagram, oldDiagram);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkHandlerDependencies() {
        try {
            DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.handlerDefs;
            int n = this.handlerDefs.length;
            int n2 = 0;
            while (true) {
                Field f;
                Object o;
                if (n2 >= n) {
                    return true;
                }
                DependencyReflection.ReferenceDefinition rd = referenceDefinitionArray[n2];
                if (rd.dependency && (o = (f = rd.field).get(this)) == null) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

