/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.SimanticsInternal;
import org.simantics.db.common.request.Adapt;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.ImmutableIndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.request.ReadInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryIndexing {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryIndexing.class);
    private final Session session;
    final Map<String, Map<String, List<Map<String, Object>>>> persistentCache = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    final Map<String, Map<String, List<Resource>>> persistentCacheResources = new ConcurrentHashMap<String, Map<String, List<Resource>>>();
    private final ConcurrentHashMap<String, RAMDirectory> directories = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IndexedRelationsSearcherBase> immutableSearchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IndexedRelationsSearcher> searchers = new ConcurrentHashMap();

    public MemoryIndexing(Session session) {
        this.session = session;
    }

    protected Path getIndexDirectory(Resource relation, Resource input) {
        return DatabaseIndexing.getIndexLocation(this.session, relation, input);
    }

    List<IndexedRelationsSearcherBase> getAllSearchers() {
        ArrayList<IndexedRelationsSearcherBase> r = new ArrayList<IndexedRelationsSearcherBase>();
        r.addAll(this.searchers.values());
        r.addAll(this.immutableSearchers.values());
        return r;
    }

    public IndexedRelationsSearcher get(RequestProcessor processor, Resource relation, Resource input) {
        Path location = this.getIndexDirectory(relation, input);
        String key = location.toAbsolutePath().toString();
        return this.searchers.computeIfAbsent(key, t -> {
            try {
                GenericRelation r = (GenericRelation)processor.sync((ReadInterface)new Adapt(relation, GenericRelation.class));
                return new IndexedRelationsSearcher(processor, relation, input, r);
            }
            catch (Exception e) {
                LOGGER.error("Could not get searcher for relation {} and input {} in location {}", new Object[]{relation, input, location, e});
                return null;
            }
        });
    }

    public IndexedRelationsSearcherBase getImmutable(RequestProcessor processor, Resource relation, Resource input) {
        Path location = this.getIndexDirectory(relation, input);
        String key = location.toAbsolutePath().toString();
        return this.immutableSearchers.computeIfAbsent(key, t -> {
            try {
                return new ImmutableIndexedRelationsSearcher(processor, relation, input);
            }
            catch (Exception e) {
                LOGGER.error("Could not get searcher base for relation {} and input {} in location {}", new Object[]{relation, input, location, e});
                return null;
            }
        });
    }

    public static MemoryIndexing getInstance(Session session) {
        MemoryIndexing ret = (MemoryIndexing)session.peekService(MemoryIndexing.class);
        if (ret == null) {
            ret = new MemoryIndexing(session);
            session.registerService(MemoryIndexing.class, (Object)ret);
        }
        return ret;
    }

    public Directory getDirectory(String path, Analyzer analyzer) throws IOException {
        try {
            return (Directory)this.directories.computeIfAbsent(path, t -> {
                try {
                    RAMDirectory directory = new RAMDirectory();
                    IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_9, analyzer);
                    new IndexWriter((Directory)directory, config.setOpenMode(IndexWriterConfig.OpenMode.CREATE)).close();
                    return directory;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
    }

    public void remove(String path) {
        this.directories.remove(path);
    }

    @Deprecated
    public void flush(IProgressMonitor progress) throws Exception {
        Session s = SimanticsInternal.getSession();
        ((IndexedRelations)s.getService(IndexedRelations.class)).flush(progress, s);
    }
}

