/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.function;

import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleResource;
import org.simantics.db.layer0.request.PossibleVariableIndexRoot;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.document.DocumentResource;
import org.simantics.document.DocumentUtils;
import org.simantics.document.ui.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.function.FunctionImpl3;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class All {
    private static final Logger LOGGER = LoggerFactory.getLogger(All.class);
    private static final Function1<Object, Boolean> PERFORM_DEFAULT_ACTION_FOR_URI_RESOURCE = new Function1<Object, Boolean>(){

        public Boolean apply(Object p0) {
            LocationEvent le = (LocationEvent)p0;
            if (le.location.startsWith("http://simantics-internal/")) {
                le.doit = false;
                String uri = le.location.substring("http://simantics-internal/".length());
                try {
                    Session s = Simantics.getSession();
                    Object input = RequestUtil.trySyncRequest((Session)s, (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Read)new ResolveURI(uri));
                    if (input != null) {
                        DefaultActions.asyncPerformDefaultAction((Session)s, (Object)input, (boolean)false, (boolean)false, (boolean)false);
                    }
                }
                catch (InterruptedException | DatabaseException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.document.ui", "Failed to resolve URI to a database resource or variable: " + uri, e));
                }
            }
            return true;
        }
    };

    private static Resource getDocumentedResource(ReadGraph graph, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
        return selection != null ? selection.getPossibleRepresents(graph) : null;
    }

    private static NavigableMap<Double, Resource> getDocumentTypeBindings(ReadGraph graph, Resource forResource, Resource indexRoot) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(DOC.DocumentTypeBinding, Instances.class);
        Collection foundBindings = query.find(graph, indexRoot);
        if (foundBindings.isEmpty()) {
            return Collections.emptyNavigableMap();
        }
        Set forResourceTypes = graph.getTypes(forResource);
        TreeMap<Double, Resource> bindings = new TreeMap<Double, Resource>();
        for (Resource binding : foundBindings) {
            double priority = (Double)graph.getRelatedValue2(binding, DOC.DocumentTypeBinding_priority, (Binding)Bindings.DOUBLE);
            Resource type = graph.getSingleObject(binding, DOC.DocumentTypeBinding_HasType);
            if (!forResourceTypes.contains(type)) continue;
            bindings.put(priority, binding);
        }
        return bindings;
    }

    private static boolean createDocument(WriteGraph graph, Resource resource, Resource indexRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        if (graph.hasStatement(resource, DOC.HasDocumentation)) {
            return true;
        }
        NavigableMap<Double, Resource> bindings = All.getDocumentTypeBindings((ReadGraph)graph, resource, indexRoot);
        if (bindings.isEmpty()) {
            return false;
        }
        Resource binding = bindings.lastEntry().getValue();
        Resource documentType = graph.getSingleObject(binding, DOC.DocumentTypeBinding_HasDocumentType);
        Resource document = graph.newResource();
        graph.claim(document, L0.InstanceOf, null, DOC.ScenegraphDocument);
        graph.claimLiteral(document, L0.HasName, (Object)"Documentation");
        graph.claim(resource, DOC.HasDocumentation, document);
        graph.claim(document, L0.PartOf, resource);
        Resource scenegraph = graph.newResource();
        graph.claim(scenegraph, L0.InstanceOf, null, documentType);
        graph.claimLiteral(scenegraph, L0.HasName, (Object)"Scenegraph");
        graph.claim(scenegraph, L0.PartOf, document);
        graph.claim(document, DOC.ScenegraphDocument_scenegraph, scenegraph);
        return true;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object onCreateDocumentButton(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(Object _o) {
                Simantics.async((ReadInterface)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
                        if (selection == null) {
                            return;
                        }
                        Resource input = selection.getPossibleRepresents(graph);
                        if (input == null) {
                            return;
                        }
                        graph.asyncRequest(wg -> {
                            Resource indexRoot = (Resource)wg.sync((ReadInterface)new PossibleVariableIndexRoot(selection));
                            if (indexRoot != null) {
                                All.createDocument(wg, input, indexRoot);
                            }
                        });
                    }
                });
                return true;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object onDeleteDocumentButton(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(Object _o) {
                Simantics.async((ReadInterface)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Resource input = All.getDocumentedResource(graph, context);
                        if (input == null) {
                            return;
                        }
                        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                        if (!graph.hasStatement(input, DOC.HasDocumentation)) {
                            return;
                        }
                        graph.asyncRequest(wg -> {
                            Resource document = wg.getPossibleObject(input, documentResource.HasDocumentation);
                            if (document != null) {
                                RemoverUtil.remove((WriteGraph)wg, (Resource)document);
                                wg.markUndoPoint();
                            }
                        });
                    }
                });
                return true;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object editorLoaded(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new FunctionImpl3<WriteGraph, Variable, Variable, Boolean>(){

            public Boolean apply(WriteGraph graph, Variable editor, Variable input) {
                return true;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static Boolean hasDocument(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource input = All.getDocumentedResource(graph, context);
        if (input == null) {
            return false;
        }
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        return graph.hasStatement(input, DOC.HasDocumentation);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object viewInputChanged(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new FunctionImpl1<Variable, Boolean>(){

            public Boolean apply(Variable viewVariable) {
                return true;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Variable -> Boolean")
    public static Boolean isWikitext(ReadGraph graph, Variable context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        Resource p = context.getPossiblePredicateResource(graph);
        if (p == null) {
            return Boolean.FALSE;
        }
        Resource range = graph.getPossibleObject(p, L0.HasRange);
        return DOC.WikiDocument_WikiText.equals(range);
    }

    private static Variable getDefaultSelection(ReadGraph graph, Variable context) throws DatabaseException {
        Variable userDoc;
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        Variable sel = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        Resource represents = sel.getRepresents(graph);
        Resource doc = graph.getSingleObject(represents, DOC.HasDocument);
        Resource scenegraph = graph.getSingleObject(doc, DOC.ScenegraphDocument_scenegraph);
        Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable((ReadGraph)graph, (Variable)context);
        INode root = (INode)runtime.adapt(graph, INode.class);
        Variable result = ScenegraphLoaderProcess.getVariable((RequestProcessor)graph, null, (Resource)scenegraph, (Resource)ScenegraphLoaderUtils.getRuntime((ReadGraph)graph, (Variable)context), (INode)root);
        if (result != null && (userDoc = result.getPossibleProperty(graph, "UserDocumentation")) != null) {
            return userDoc;
        }
        return null;
    }

    private static Variable resolveEditSelection(ReadGraph graph, Variable context, String path) throws DatabaseException {
        ScenegraphLoaderUtils.ScenegraphPropertyReference selectionReference = ScenegraphLoaderUtils.getRelativePropertyReference((IThreadWorkQueue)SWTThread.getThreadAccess(), (ReadGraph)graph, (Variable)context, (String)path);
        Variable editSelection = (Variable)selectionReference.getExternalValue((RequestProcessor)graph);
        if (editSelection == null) {
            editSelection = All.getDefaultSelection(graph, context);
        }
        return editSelection;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object wikitextModifier(ReadGraph graph, final Resource resource, final Variable context) throws DatabaseException {
        final ScenegraphLoaderUtils.ScenegraphPropertyReference textReference = ScenegraphLoaderUtils.getRelativePropertyReference((IThreadWorkQueue)SWTThread.getThreadAccess(), (ReadGraph)graph, (Variable)context, (String)".../TextContainer/Text#text");
        return new FunctionImpl1<Object, Object>(){

            public Object apply(Object event) {
                final String value = (String)textReference.getValue();
                try {
                    Simantics.getSession().sync((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Variable selection = All.resolveEditSelection((ReadGraph)graph, context, "..../Scroll/Browser#edited");
                            if (selection != null) {
                                selection.setValue(graph, (Object)value, (Binding)Bindings.STRING);
                                graph.markUndoPoint();
                            } else {
                                LOGGER.error("No selection for resource : " + resource + ", Variable context : " + context + ", value : " + value);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String wikitext(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        return (String)selection.getValue(graph);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String selectedDocumentPart(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = All.resolveEditSelection(graph, context, ".../Scroll/Browser#edited");
        if (selection == null) {
            return null;
        }
        return (String)selection.getValue(graph);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object documentStructureSelected(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Boolean>(){

            public Boolean apply(Object _event) {
                Event event = (Event)_event;
                TreeItem item = (TreeItem)event.item;
                NodeContext context = (NodeContext)item.getData();
                Variable entry = (Variable)context.getConstant(BuiltinKeys.INPUT);
                ISelectionProvider provider = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider();
                provider.setSelection((ISelection)new StructuredSelection((Object)entry));
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object boldModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                if (selected.isEmpty()) {
                    this.textReference.setValue((Object)(String.valueOf(before) + "'''bold text'''" + after));
                } else {
                    this.textReference.setValue((Object)(String.valueOf(before) + "'''" + selected + "'''" + after));
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object italicModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                if (selected.isEmpty()) {
                    this.textReference.setValue((Object)(String.valueOf(before) + "''italic text''" + after));
                } else {
                    this.textReference.setValue((Object)(String.valueOf(before) + "''" + selected + "''" + after));
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object strikethroughModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                if (selected.isEmpty()) {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<span style=\"text-decoration:line-through;\">strikethrough text</span>" + after));
                } else {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<span style=\"text-decoration:line-through;\">" + selected + "</span>" + after));
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object underlineModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                if (selected.isEmpty()) {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<span style=\"text-decoration:underline;\">strikethrough text</span>" + after));
                } else {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<span style=\"text-decoration:underline;\">" + selected + "</span>" + after));
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object horizontalRulerModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n<hr/>\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object indentModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + ":" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object fontModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            private String hex2(int value) {
                String result = Integer.toHexString(value);
                if (result.length() == 1) {
                    result = "0" + result;
                }
                return result;
            }

            @Override
            void perform(String before, String selected, String after, Point selection) {
                FontDialog dialog = new FontDialog(Display.getCurrent().getActiveShell());
                FontData data = dialog.open();
                if (data == null) {
                    return;
                }
                String family = data.getName();
                int size = data.getHeight();
                RGB rgb = dialog.getRGB();
                String hex = String.valueOf(this.hex2(rgb.red)) + this.hex2(rgb.green) + this.hex2(rgb.blue);
                if (selected.isEmpty()) {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<font style=\"font-size:" + size + ";color: #" + hex + ";font-family:" + family + ";\" >formatted text</font>" + selected + after));
                } else {
                    this.textReference.setValue((Object)(String.valueOf(before) + "<font style=\"font-size:" + size + ";color: #" + hex + ";font-family:" + family + ";\" >" + selected + "</font>" + after));
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object imageModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "[[Image:root://Library/image.png|100px]]" + "\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object header1Modifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n= Header 1 =\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object header2Modifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n== Header 2 ==\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object header3Modifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n=== Header 3 ===\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object header4Modifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n==== Header 4 ====\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object numberedListModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n" + "# Item1\r\n" + "# Item2\r\n" + "## Item2.1\r\n" + "# Item3\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object bulletListModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n" + "* Item1\r\n" + "* Item2\r\n" + "** Item2.1\r\n" + "* Item3\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object tableModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "\r\n" + "{| border=\"1\"\r\n" + "! header\r\n" + "! header2 \r\n" + "|-\r\n" + "| cell || cell2\r\n" + "|-\r\n" + "| cell3\r\n" + "| cell4\r\n" + "|}\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object internalLinkModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "[[Media:root://Documents/Document.pdf|Link to a file within the model]]\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object linkModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                this.textReference.setValue((Object)(String.valueOf(before) + "[http://www.simantics.org External Website Link]\r\n" + selected + after));
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object styleModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new WikiButtonModifier(graph, context){

            @Override
            void perform(String before, String selected, String after, Point selection) {
                Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Variable sel = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
                        Resource root = sel.getIndexRoot(graph);
                        String editorId = "org.simantics.document.ui.csseditor";
                        RVI rvi = null;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                            try {
                                WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, root, root, rvi));
                            }
                            catch (PartInitException e) {
                                LOGGER.error("Failed to open CSS editor for root " + root, (Throwable)e);
                            }
                        });
                    }
                });
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String noDocumentText(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
        if (selection == null) {
            return "<no input>";
        }
        Resource input = selection.getPossibleRepresents(graph);
        if (input == null) {
            return "<no input>";
        }
        String path = DocumentUtils.indexRootPath((ReadGraph)graph, (Variable)selection);
        if (!path.isEmpty()) {
            return "for " + path + selection.getName(graph);
        }
        return "for " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)input);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static Boolean canCreateDocument(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
        if (selection == null) {
            return false;
        }
        Resource input = selection.getPossibleRepresents(graph);
        if (input == null) {
            return false;
        }
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleVariableIndexRoot(selection));
        if (indexRoot == null) {
            return false;
        }
        NavigableMap<Double, Resource> bindings = All.getDocumentTypeBindings(graph, input, indexRoot);
        if (bindings.isEmpty()) {
            return false;
        }
        return true;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Object, Boolean> locationChanging(ReadGraph graph, Resource variable, Variable context) throws DatabaseException {
        return PERFORM_DEFAULT_ACTION_FOR_URI_RESOURCE;
    }

    private static class ResolveURI
    extends UnaryRead<String, Object> {
        public ResolveURI(String uri) {
            super((Object)uri);
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            Object result = graph.syncRequest((Read)new PossibleResource((String)this.parameter));
            if (result == null) {
                result = Variables.getPossibleVariable((ReadGraph)graph, (String)((String)this.parameter));
            }
            return result;
        }
    }

    static abstract class WikiButtonModifier
    extends FunctionImpl1<Object, Object> {
        final ScenegraphLoaderUtils.ScenegraphPropertyReference<String> textReference;
        final ScenegraphLoaderUtils.ScenegraphPropertyReference<Point> selectionReference;

        public WikiButtonModifier(ReadGraph graph, Variable context) throws DatabaseException {
            this.textReference = ScenegraphLoaderUtils.getRelativePropertyReference((IThreadWorkQueue)SWTThread.getThreadAccess(), (ReadGraph)graph, (Variable)context, (String)".../TextContainer/Text#text");
            this.selectionReference = ScenegraphLoaderUtils.getRelativePropertyReference((IThreadWorkQueue)SWTThread.getThreadAccess(), (ReadGraph)graph, (Variable)context, (String)".../TextContainer/Text#selection");
        }

        abstract void perform(String var1, String var2, String var3, Point var4);

        public Object apply(Object _event) {
            String text = (String)this.textReference.getValue();
            Point selection = (Point)this.selectionReference.getValue();
            String before = text.substring(0, selection.x);
            String selected = text.substring(selection.x, selection.y);
            String after = text.substring(selection.y);
            this.perform(before, selected, after, selection);
            return null;
        }
    }
}

