/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.SelectionFilter;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGECache;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.DefaultCheckedStateProcessor;
import org.simantics.browsing.ui.common.processors.DefaultComparableChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultFinalChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultHasChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImageDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultPrunedChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedImageDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointFactoryProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionsProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointProcessor;
import org.simantics.browsing.ui.common.processors.IsExpandedProcessor;
import org.simantics.browsing.ui.common.processors.NoSelectionRequestProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.state.ExplorerStates;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.ComboBoxCellEditor2;
import org.simantics.browsing.ui.swt.DefaultImageDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultIsExpandedProcessor;
import org.simantics.browsing.ui.swt.DefaultLabelDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultSelectedImagerProcessor;
import org.simantics.browsing.ui.swt.DefaultShowMaxChildrenProcessor;
import org.simantics.browsing.ui.swt.GraphExplorerImplBase;
import org.simantics.browsing.ui.swt.ImageLoaderJob;
import org.simantics.browsing.ui.swt.ViewerCellReference;
import org.simantics.browsing.ui.swt.ViewerRowReference;
import org.simantics.browsing.ui.swt.internal.Threads;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;

public class GraphExplorerImpl2
extends GraphExplorerImplBase
implements GraphExplorer {
    private static final boolean DEBUG_SELECTION_LISTENERS = false;
    private static final boolean DEBUG = false;
    private TreeViewer viewer;
    private LocalResourceManager localResourceManager;
    private DeviceResourceManager resourceManager;
    private IThreadWorkQueue thread;
    final HashMap<NodeContext.CacheKey<?>, NodeQueryProcessor> processors = new HashMap();
    final HashMap<Object, PrimitiveQueryProcessor> primitiveProcessors = new HashMap();
    final HashMap<Class, DataSource> dataSources = new HashMap();
    private FontDescriptor originalFont;
    protected ColorDescriptor originalForeground;
    protected ColorDescriptor originalBackground;
    private Color invalidModificationColor;
    private Column[] columns;
    private Map<String, Integer> columnKeyToIndex;
    private boolean columnsAreVisible = true;
    private NodeContext rootContext;
    private TreeNode rootNode;
    private StatePersistor persistor = null;
    private boolean editable = true;
    private boolean disposed = false;
    private final CopyOnWriteArrayList<FocusListener> focusListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MouseListener> mouseListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<KeyListener> keyListeners = new CopyOnWriteArrayList();
    private int autoExpandLevel = 0;
    private IServiceLocator serviceLocator;
    private IContextService contextService = null;
    private IFocusService focusService = null;
    private IContextActivation editingContext = null;
    GeViewerContext explorerContext = new GeViewerContext(this);
    private GraphExplorerPostSelectionProvider postSelectionProvider = new GraphExplorerPostSelectionProvider(this);
    private BasePostSelectionProvider selectionProvider = new BasePostSelectionProvider();
    private SelectionDataResolver selectionDataResolver;
    private SelectionFilter selectionFilter;
    private Set<TreeNode> collapsedNodes = new HashSet<TreeNode>();
    private MapList<NodeContext, TreeNode> contextToNodeMap = new MapList();
    private GraphExplorer.ModificationContext modificationContext = null;
    private boolean filterSelectionEdit = true;
    private TreeColumnLayout treeColumnLayout;
    private boolean expand;
    private boolean verticalBarVisible = false;
    private BiFunction<GraphExplorer, Object[], Object[]> selectionTransformation = new BiFunction<GraphExplorer, Object[], Object[]>(){

        @Override
        public Object[] apply(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                AdaptableHintContext context = new AdaptableHintContext(new IHintContext.Key[]{SelectionHints.KEY_MAIN});
                context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                result[i] = context;
                ++i;
            }
            return result;
        }
    };
    private TransientStateImpl transientState = new TransientStateImpl();
    private long focusGainedAt = 0L;
    private boolean visible = false;
    private Collection<TreeNode> selectedNodes = new ArrayList<TreeNode>();
    private NodeContext pendingRoot;
    private List<TreeViewerColumn> treeViewerColumns = new ArrayList<TreeViewerColumn>();
    private CellLabelProvider cellLabelProvider = new GeViewerLabelProvider();
    private List<EditingSupport> editingSupports = new ArrayList<EditingSupport>();
    private Set<String> uiContexts;
    int maxChildren = 1000;
    private HashSet<UpdateItem> pendingItems = new HashSet();
    private boolean updating = false;
    private int updateCounter = 0;
    final ScheduledExecutorService uiUpdateScheduler = ThreadUtils.getNonBlockingWorkExecutor();
    final ExecutorService queryUpdateScheduler = Threads.getExecutor();
    ImageLoaderJob imageLoaderJob;
    Map<TreeNode, ImageTask> imageTasks = new THashMap();

    public GraphExplorerImpl2(Composite parent) {
        this(parent, 2050);
    }

    public GraphExplorerImpl2(Composite parent, int style) {
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.resourceManager = new DeviceResourceManager((Device)parent.getDisplay());
        this.imageLoaderJob = new ImageLoaderJob(this);
        this.imageLoaderJob.setPriority(50);
        this.invalidModificationColor = (Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128)));
        this.thread = SWTThread.getThreadAccess((Widget)parent);
        int i = 0;
        while (i < 10) {
            this.explorerContext.activity.push(0);
            ++i;
        }
        boolean useLayout = true;
        if (useLayout && !(parent.getLayout() instanceof TreeColumnLayout)) {
            Composite rootTreeComposite = new Composite(parent, 0);
            this.treeColumnLayout = new TreeColumnLayout();
            rootTreeComposite.setLayout((Layout)this.treeColumnLayout);
            this.viewer = new TreeViewer(rootTreeComposite, style | 0x100 | 0x200);
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)rootTreeComposite);
        } else {
            this.viewer = new TreeViewer(parent, style | 0x100 | 0x200);
        }
        this.viewer.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                if ((long)event.time - GraphExplorerImpl2.this.focusGainedAt < 250L) {
                    event.cancel = true;
                }
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }
        });
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new GeViewerContentProvider());
        this.originalFont = JFaceResources.getDefaultFontDescriptor();
        this.viewer.getTree().setFont((Font)this.localResourceManager.get((DeviceResourceDescriptor)this.originalFont));
        this.setBasicListeners();
        this.setDefaultProcessors();
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GraphExplorerImpl2.this.doDispose();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: 
                    case 22: 
                    case 26: {
                        GraphExplorerImpl2.this.visible = true;
                        GraphExplorerImpl2.this.activate();
                        break;
                    }
                    case 23: 
                    case 27: {
                        GraphExplorerImpl2.this.visible = false;
                    }
                }
            }
        };
        this.viewer.getTree().addListener(26, listener);
        this.viewer.getTree().addListener(27, listener);
        this.viewer.getTree().addListener(22, listener);
        this.viewer.getTree().addListener(23, listener);
        this.viewer.getTree().addListener(9, listener);
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                GraphExplorerImpl2.this.collapsedNodes.add((TreeNode)event.getElement());
            }
        });
        this.setColumns(new Column[]{new Column("single")});
    }

    protected void setBasicListeners() {
        Tree tree = this.viewer.getTree();
        tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                GraphExplorerImpl2.this.focusGainedAt = (long)e.time & 0xFFFFFFFFL;
                for (FocusListener listener : GraphExplorerImpl2.this.focusListeners) {
                    listener.focusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                for (FocusListener listener : GraphExplorerImpl2.this.focusListeners) {
                    listener.focusLost(e);
                }
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl2.this.mouseListeners) {
                    listener.mouseDoubleClick(e);
                }
            }

            public void mouseDown(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl2.this.mouseListeners) {
                    listener.mouseDown(e);
                }
            }

            public void mouseUp(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl2.this.mouseListeners) {
                    listener.mouseUp(e);
                }
            }
        });
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                for (KeyListener listener : GraphExplorerImpl2.this.keyListeners) {
                    listener.keyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                for (KeyListener listener : GraphExplorerImpl2.this.keyListeners) {
                    listener.keyReleased(e);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GraphExplorerImpl2.this.selectedNodes = AdaptionUtils.adaptToCollection((Object)event.getSelection(), TreeNode.class);
                Collection selectedContexts = AdaptionUtils.adaptToCollection((Object)event.getSelection(), NodeContext.class);
                GraphExplorerImpl2.this.selectionProvider.setAndFireSelection(GraphExplorerImpl2.this.constructSelection(selectedContexts.toArray(new NodeContext[selectedContexts.size()])));
            }
        });
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Collection selectedContexts = AdaptionUtils.adaptToCollection((Object)event.getSelection(), NodeContext.class);
                GraphExplorerImpl2.this.selectionProvider.firePostSelection(GraphExplorerImpl2.this.constructSelection(selectedContexts.toArray(new NodeContext[selectedContexts.size()])));
            }
        });
    }

    private void activate() {
        if (this.pendingRoot != null && !this.expand) {
            this.doSetRoot(this.pendingRoot);
            this.pendingRoot = null;
        }
    }

    private void doSetRoot(NodeContext root) {
        GeViewerContext newContext;
        Display display = this.viewer.getTree().getDisplay();
        if (display.getThread() != Thread.currentThread()) {
            throw new RuntimeException("Invoke from SWT thread only");
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        if (root.getConstant(BuiltinKeys.INPUT) == null) {
            ErrorLogger.defaultLogError((String)("root node context does not contain BuiltinKeys.INPUT key. Node = " + root), (Throwable)new Exception("trace"));
            return;
        }
        if (this.rootNode != null) {
            this.rootNode.dispose();
        }
        GeViewerContext oldContext = this.explorerContext;
        this.explorerContext = newContext = new GeViewerContext(this);
        oldContext.safeDispose();
        this.clearPrimitiveProcessors();
        this.rootContext = root.getConstant(BuiltinKeys.IS_ROOT) != null ? root : NodeContextUtil.withConstant((NodeContext)root, (NodeContext.ConstantKey)BuiltinKeys.IS_ROOT, (Object)Boolean.TRUE);
        this.explorerContext.getCache().incRef(this.rootContext);
        this.initializeState();
        this.select(this.rootContext);
        this.rootNode = new TreeNode(this.rootContext);
        this.viewer.setInput((Object)this.rootNode);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphExplorerImpl2.this.rootNode != null) {
                    GraphExplorerImpl2.this.rootNode.updateChildren();
                }
            }
        });
    }

    private void initializeState() {
        if (this.persistor == null) {
            return;
        }
        ExplorerStates.scheduleRead((NodeContext)this.getRoot(), (StatePersistor)this.persistor).thenAccept(state -> {
            boolean bl = SWTUtils.asyncExec((Widget)this.viewer.getTree(), () -> this.restoreState((ExplorerState)state));
        });
    }

    private void restoreState(ExplorerState state) {
        PrimitiveQueryProcessor processor = this.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED);
        if (processor instanceof DefaultIsExpandedProcessor) {
            DefaultIsExpandedProcessor isExpandedProcessor = (DefaultIsExpandedProcessor)processor;
            for (NodeContext expanded : state.expandedNodes) {
                isExpandedProcessor.replaceExpanded(expanded, true);
            }
        }
    }

    public NodeContext getRoot() {
        return this.rootContext;
    }

    public IThreadWorkQueue getThread() {
        return this.thread;
    }

    public NodeContext getParentContext(NodeContext context) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        List nodes = this.contextToNodeMap.getValuesUnsafe((Object)context);
        int i = 0;
        while (i < nodes.size()) {
            if (((TreeNode)nodes.get(i)).getParent() != null) {
                return ((TreeNode)nodes.get(i)).getParent().getContext();
            }
            ++i;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        if (IPostSelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        return null;
    }

    protected void setDefaultProcessors() {
        this.setProcessor((NodeQueryProcessor)new DefaultComparableChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImageDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelerFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImagerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImagerFactoriesProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultCheckedStateProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImagerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImageDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new NoSelectionRequestProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultFinalChildrenProcessor((GraphExplorer)this));
        this.setProcessor((NodeQueryProcessor)new DefaultHasChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultPrunedChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedViewpointProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImageDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultViewpointContributionsProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointContributionProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultSelectedViewpointFactoryProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new TreeNodeIsExpandedProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultShowMaxChildrenProcessor());
    }

    public Column[] getColumns() {
        return java.util.Arrays.copyOf(this.columns, this.columns.length);
    }

    public void setColumnsVisible(boolean visible) {
        this.columnsAreVisible = visible;
        if (this.viewer.getTree() != null) {
            this.viewer.getTree().setHeaderVisible(this.columnsAreVisible);
        }
    }

    public void setColumns(Column[] columns) {
        this.setColumns(columns, null);
    }

    public void setColumns(final Column[] columns, final Consumer<Map<Column, Object>> callback) {
        this.assertNotDisposed();
        this.checkUniqueColumnKeys(columns);
        Display d = this.viewer.getTree().getDisplay();
        if (d.getThread() == Thread.currentThread()) {
            this.doSetColumns(columns, callback);
            this.viewer.refresh(true);
        } else {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl2.this.viewer == null) {
                        return;
                    }
                    if (GraphExplorerImpl2.this.viewer.getTree().isDisposed()) {
                        return;
                    }
                    GraphExplorerImpl2.this.doSetColumns(columns, callback);
                    GraphExplorerImpl2.this.viewer.refresh(true);
                    GraphExplorerImpl2.this.viewer.getTree().getParent().layout();
                }
            });
        }
    }

    private void checkUniqueColumnKeys(Column[] cols) {
        HashSet<String> usedColumnKeys = new HashSet<String>();
        ArrayList<Column> duplicateColumns = new ArrayList<Column>();
        Column[] columnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (!usedColumnKeys.add(c.getKey())) {
                duplicateColumns.add(c);
            }
            ++n2;
        }
        if (!duplicateColumns.isEmpty()) {
            throw new IllegalArgumentException("All columns do not have unique keys: " + cols + ", overlapping: " + duplicateColumns);
        }
    }

    private void doSetColumns(Column[] cols, Consumer<Map<Column, Object>> callback) {
        HashMap<String, Integer> prevWidths = new HashMap<String, Integer>();
        for (TreeViewerColumn c : this.treeViewerColumns) {
            Column col = (Column)c.getColumn().getData();
            if (col != null) {
                prevWidths.put(col.getKey(), c.getColumn().getWidth());
            }
            c.getColumn().dispose();
        }
        this.treeViewerColumns.clear();
        HashMap<String, Integer> keyToIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < cols.length) {
            keyToIndex.put(cols[i].getKey(), i);
            ++i;
        }
        this.columns = java.util.Arrays.copyOf(cols, cols.length);
        this.columnKeyToIndex = keyToIndex;
        HashMap<Column, TreeColumn> map = new HashMap<Column, TreeColumn>();
        this.viewer.getTree().setHeaderVisible(this.columns.length == 1 ? false : this.columnsAreVisible);
        int columnIndex = 0;
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn tvc = new TreeViewerColumn(this.viewer, this.toSWT(column.getAlignment()));
            this.treeViewerColumns.add(tvc);
            tvc.setLabelProvider(this.cellLabelProvider);
            EditingSupport support = null;
            if (this.editingSupports.size() > columnIndex) {
                support = this.editingSupports.get(columnIndex);
            } else {
                support = new GeEditingSupport((ColumnViewer)this.viewer, columnIndex);
                this.editingSupports.add(support);
            }
            tvc.setEditingSupport(support);
            TreeColumn c = tvc.getColumn();
            map.put(column, c);
            c.setData((Object)column);
            c.setText(column.getLabel());
            c.setToolTipText(column.getTooltip());
            int cw = column.getWidth();
            Integer w = (Integer)prevWidths.get(column.getKey());
            if (w != null) {
                c.setWidth(w.intValue());
            } else if (cw != -1) {
                c.setWidth(cw);
            } else if (this.columns.length == 1) {
                c.setWidth(1000);
            } else if ("Property".equals(column.getKey())) {
                c.setWidth(150);
            } else {
                c.setWidth(50);
            }
            if (this.treeColumnLayout != null) {
                this.treeColumnLayout.setColumnData((Widget)c, (ColumnLayoutData)new ColumnWeightData(column.getWeight(), true));
            }
            ++columnIndex;
            ++n2;
        }
        if (callback != null) {
            callback.accept(map);
        }
    }

    int toSWT(Column.Align alignment) {
        switch (alignment) {
            case LEFT: {
                return 16384;
            }
            case CENTER: {
                return 0x1000000;
            }
            case RIGHT: {
                return 131072;
            }
        }
        throw new Error("unhandled alignment: " + alignment);
    }

    public <T> void setProcessor(NodeQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        this.processors.put((NodeContext.CacheKey<?>)processor.getIdentifier(), (NodeQueryProcessor)processor);
    }

    public <T> void setPrimitiveProcessor(PrimitiveQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        PrimitiveQueryProcessor<T> oldProcessor = this.primitiveProcessors.put(processor.getIdentifier(), processor);
        if (oldProcessor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)oldProcessor).detached((GraphExplorer)this);
        }
        if (processor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)processor).attached((GraphExplorer)this);
        }
    }

    public <T> void setDataSource(DataSource<T> provider) {
        this.assertNotDisposed();
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        this.dataSources.put(provider.getProvidedClass(), provider);
    }

    public <T> DataSource<T> removeDataSource(Class<T> forProvidedClass) {
        this.assertNotDisposed();
        if (forProvidedClass == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.dataSources.remove(forProvidedClass);
    }

    public void setPersistor(StatePersistor persistor) {
        this.persistor = persistor;
    }

    public SelectionDataResolver getSelectionDataResolver() {
        return this.selectionDataResolver;
    }

    public void setSelectionDataResolver(SelectionDataResolver r) {
        this.selectionDataResolver = r;
    }

    public SelectionFilter getSelectionFilter() {
        return this.selectionFilter;
    }

    public void setSelectionFilter(SelectionFilter f) {
        this.selectionFilter = f;
    }

    protected ISelection constructSelection(NodeContext ... contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("null contexts");
        }
        if (contexts.length == 0) {
            return StructuredSelection.EMPTY;
        }
        if (this.selectionFilter == null) {
            return new StructuredSelection(this.transformSelection(contexts));
        }
        return new StructuredSelection(this.transformSelection(GraphExplorerImpl2.filter(this.selectionFilter, contexts)));
    }

    protected Object[] transformSelection(Object[] objects) {
        return this.selectionTransformation.apply(this, objects);
    }

    protected static Object[] filter(SelectionFilter filter, NodeContext[] contexts) {
        int len = contexts.length;
        Object[] objects = new Object[len];
        int i = 0;
        while (i < len) {
            objects[i] = filter.filter(contexts[i]);
            ++i;
        }
        return objects;
    }

    public void setSelectionTransformation(BiFunction<GraphExplorer, Object[], Object[]> f) {
        this.selectionTransformation = f;
    }

    public ISelection getWidgetSelection() {
        return this.viewer.getSelection();
    }

    public <T> void addListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.add((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.add((MouseListener)listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.add((KeyListener)listener);
        }
    }

    public <T> void removeListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.remove(listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.remove(listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.remove(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.viewer.getTree().addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.viewer.getTree().removeSelectionListener(listener);
    }

    public void setUIContexts(Set<String> contexts) {
        this.uiContexts = contexts;
    }

    public void setRoot(Object root) {
        if (this.uiContexts != null && this.uiContexts.size() == 1) {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root, BuiltinKeys.UI_CONTEXT, this.uiContexts.iterator().next()}));
        } else {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root}));
        }
    }

    public void setRootContext(NodeContext context) {
        this.setRootContext0(context);
    }

    private void setRoot(NodeContext context) {
        if (!this.visible) {
            this.pendingRoot = context;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl2.this.viewer != null && !GraphExplorerImpl2.this.viewer.getTree().isDisposed()) {
                        GraphExplorerImpl2.this.viewer.getTree().redraw();
                    }
                }
            });
            return;
        }
        this.doSetRoot(context);
    }

    private void setRootContext0(final NodeContext context) {
        Assert.isNotNull((Object)context, (String)"root must not be null");
        if (this.isDisposed() || this.viewer.getTree().isDisposed()) {
            return;
        }
        Display display = this.viewer.getTree().getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.setRoot(context);
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphExplorerImpl2.this.setRoot(context);
                }
            });
        }
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public <T> T getControl() {
        return (T)this.viewer.getTree();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("disposed");
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        this.editable = editable;
        Display display = this.viewer.getTree().getDisplay();
        this.viewer.getTree().setBackground(editable ? null : display.getSystemColor(22));
    }

    private void doDispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.explorerContext.dispose();
        this.explorerContext = null;
        this.processors.clear();
        this.detachPrimitiveProcessors();
        this.primitiveProcessors.clear();
        this.dataSources.clear();
        this.pendingItems.clear();
        this.rootContext = null;
        this.mouseListeners.clear();
        this.selectionProvider.clearListeners();
        this.selectionProvider = null;
        this.selectionDataResolver = null;
        this.selectedNodes.clear();
        this.selectedNodes = null;
        this.selectionTransformation = null;
        this.originalFont = null;
        this.localResourceManager.dispose();
        this.localResourceManager = null;
        this.imageLoaderJob.dispose();
        this.imageLoaderJob.cancel();
        try {
            this.imageLoaderJob.join();
            this.imageLoaderJob = null;
        }
        catch (InterruptedException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.resourceManager.dispose();
        this.resourceManager = null;
        this.collapsedNodes.clear();
        this.collapsedNodes = null;
        if (this.rootNode != null) {
            this.rootNode.dispose();
            this.rootNode = null;
        }
        this.contextToNodeMap.clear();
        this.contextToNodeMap = null;
        if (this.postSelectionProvider != null) {
            this.postSelectionProvider.dispose();
            this.postSelectionProvider = null;
        }
        this.imageTasks = null;
        this.modificationContext = null;
        this.focusService = null;
        this.contextService = null;
        this.serviceLocator = null;
        this.columns = null;
        this.columnKeyToIndex.clear();
        this.columnKeyToIndex = null;
        this.viewer = null;
    }

    public boolean select(NodeContext context) {
        this.assertNotDisposed();
        if (context == null || context.equals(this.rootContext) || this.contextToNodeMap.getValuesUnsafe((Object)context).size() == 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection());
            this.selectionProvider.setAndFireNonEqualSelection((ISelection)TreeSelection.EMPTY);
            return true;
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(this.contextToNodeMap.getValuesUnsafe((Object)context).get(0)));
        return false;
    }

    public boolean selectPath(Collection<NodeContext> contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("Null list is not allowed");
        }
        if (contexts.isEmpty()) {
            throw new IllegalArgumentException("Empty list is not allowed");
        }
        return this.selectPathInternal(contexts.toArray(new NodeContext[contexts.size()]), 0);
    }

    private boolean selectPathInternal(NodeContext[] contexts, int position) {
        NodeContext head = contexts[position];
        if (position == contexts.length - 1) {
            return this.select(head);
        }
        this.setExpanded(head, true);
        if (!this.waitVisible(contexts[position + 1])) {
            return false;
        }
        return this.selectPathInternal(contexts, position + 1);
    }

    private boolean waitVisible(NodeContext context) {
        long start = System.nanoTime();
        while (!this.isVisible(context)) {
            Display.getCurrent().readAndDispatch();
            long duration = System.nanoTime() - start;
            if (!((double)duration > 1.0E10)) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible(NodeContext context) {
        if (this.contextToNodeMap.getValuesUnsafe((Object)context).size() == 0) {
            return false;
        }
        Object[] elements = this.viewer.getVisibleExpandedElements();
        return Arrays.contains((Object[])elements, this.contextToNodeMap.getValuesUnsafe((Object)context).get(0));
    }

    public GraphExplorer.TransientExplorerState getTransientState() {
        if (!this.thread.currentThreadAccess()) {
            throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".getActiveColumn called from non SWT-thread: " + Thread.currentThread()));
        }
        return this.transientState;
    }

    public <T> T query(NodeContext context, NodeContext.CacheKey<T> key) {
        return this.explorerContext.cache.get(context, key);
    }

    public void setServiceLocator(IServiceLocator serviceLocator) {
        if (serviceLocator == null && PlatformUI.isWorkbenchRunning()) {
            serviceLocator = PlatformUI.getWorkbench();
        }
        this.serviceLocator = serviceLocator;
        if (serviceLocator != null) {
            this.contextService = (IContextService)serviceLocator.getService(IContextService.class);
            this.focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        }
    }

    private void detachPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).detached((GraphExplorer)this);
        }
    }

    private void clearPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).clear();
        }
    }

    public void setExpanded(NodeContext context, boolean expanded) {
        this.viewer.setExpandedState((Object)context, expanded);
    }

    public void setAutoExpandLevel(int level) {
        this.autoExpandLevel = level;
        this.viewer.setAutoExpandLevel(level);
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public int getMaxChildren(NodeQueryManager manager, NodeContext context) {
        Integer result = (Integer)manager.query(context, BuiltinKeys.SHOW_MAX_CHILDREN);
        if (result != null) {
            if (result < 0) {
                throw new AssertionError((Object)("BuiltinKeys.SHOW_MAX_CHILDREN query must never return < 0, got " + result));
            }
            return result;
        }
        return this.maxChildren;
    }

    public <T> NodeQueryProcessor<T> getProcessor(NodeContext.QueryKey<T> key) {
        return this.explorerContext.getProcessor(key);
    }

    public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(NodeContext.PrimitiveQueryKey<T> key) {
        return this.explorerContext.getPrimitiveProcessor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TreeNode element, int columnIndex) {
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        HashSet<UpdateItem> hashSet = this.pendingItems;
        synchronized (hashSet) {
            this.pendingItems.add(new UpdateItem(element, columnIndex));
            if (this.updating) {
                return;
            }
            ++this.updateCounter;
            this.scheduleUpdater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TreeNode element) {
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        if (element != null && element.isDisposed()) {
            return;
        }
        HashSet<UpdateItem> hashSet = this.pendingItems;
        synchronized (hashSet) {
            this.pendingItems.add(new UpdateItem(element));
            if (this.updating) {
                return;
            }
            ++this.updateCounter;
            this.scheduleUpdater();
        }
    }

    boolean scheduleUpdater() {
        if (this.viewer.getTree().isDisposed()) {
            return false;
        }
        if (!this.pendingItems.isEmpty()) {
            int activity = this.explorerContext.activityInt;
            long delay = 30L;
            if (activity >= 100) {
                delay = activity < 1000 ? 500L : 3000L;
            }
            this.updateCounter = 0;
            this.uiUpdateScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl2.this.viewer == null || GraphExplorerImpl2.this.viewer.getTree().isDisposed()) {
                        return;
                    }
                    if (GraphExplorerImpl2.this.updateCounter > 0) {
                        GraphExplorerImpl2.this.updateCounter = 0;
                        GraphExplorerImpl2.this.uiUpdateScheduler.schedule(this, 50L, TimeUnit.MILLISECONDS);
                    } else {
                        GraphExplorerImpl2.this.viewer.getTree().getDisplay().asyncExec((Runnable)new UpdateRunner(GraphExplorerImpl2.this, GraphExplorerImpl2.this.explorerContext));
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.updating = true;
            return true;
        }
        return false;
    }

    public String startEditing(NodeContext context, String columnKey) {
        Integer columnIndex;
        this.assertNotDisposed();
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        if (columnKey.startsWith("#")) {
            columnKey = columnKey.substring(1);
        }
        if ((columnIndex = this.columnKeyToIndex.get(columnKey)) == null) {
            return "Rename not supported for selection";
        }
        this.viewer.editElement((Object)context, columnIndex.intValue());
        if (this.viewer.isCellEditorActive()) {
            return null;
        }
        return "Rename not supported for selection";
    }

    public String startEditing(String columnKey) {
        ISelection selection = this.postSelectionProvider.getSelection();
        if (selection == null) {
            return "Rename not supported for selection";
        }
        NodeContext context = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selection, NodeContext.class);
        if (context == null) {
            return "Rename not supported for selection";
        }
        return this.startEditing(context, columnKey);
    }

    public void setSelection(ISelection selection, boolean forceControlUpdate) {
        this.assertNotDisposed();
        boolean equalsOld = this.selectionProvider.selectionEquals(selection);
        if (equalsOld && !forceControlUpdate) {
            this.selectionProvider.setSelection(selection);
        } else {
            Collection coll = AdaptionUtils.adaptToCollection((Object)selection, NodeContext.class);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            for (NodeContext c : coll) {
                List match = this.contextToNodeMap.getValuesUnsafe((Object)c);
                if (match.size() <= 0) continue;
                nodes.add((TreeNode)match.get(0));
            }
            StructuredSelection sel = new StructuredSelection(nodes.toArray());
            if (coll.size() == 0) {
                return;
            }
            if (this.viewer.getTree().isDisposed()) {
                return;
            }
            Display d = this.viewer.getTree().getDisplay();
            if (d.getThread() == Thread.currentThread()) {
                this.viewer.setSelection((ISelection)sel);
            } else {
                d.asyncExec(new Runnable((ISelection)sel){
                    private final /* synthetic */ ISelection val$sel;
                    {
                        this.val$sel = iSelection;
                    }

                    @Override
                    public void run() {
                        if (GraphExplorerImpl2.this.viewer.getTree().isDisposed()) {
                            return;
                        }
                        GraphExplorerImpl2.this.viewer.setSelection(this.val$sel);
                    }
                });
            }
        }
    }

    public void setModificationContext(GraphExplorer.ModificationContext modificationContext) {
        this.modificationContext = modificationContext;
    }

    private Labeler.Modifier getModifier(TreeNode element, int columnIndex) {
        NodeContext context;
        GENodeQueryManager manager = element.getManager();
        Labeler labeler = (Labeler)manager.query(context = element.getContext(), BuiltinKeys.SELECTED_LABELER);
        if (labeler == null) {
            return null;
        }
        Column column = this.columns[columnIndex];
        return labeler.getModifier(this.modificationContext, column.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus setPendingImages(IProgressMonitor monitor) {
        ImageTask[] tasks = null;
        Map<TreeNode, ImageTask> map = this.imageTasks;
        synchronized (map) {
            tasks = this.imageTasks.values().toArray(new ImageTask[this.imageTasks.size()]);
            this.imageTasks.clear();
        }
        IStatus status = null;
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            Object desc = task.descsOrImage;
            if (desc instanceof ImageDescriptor) {
                try {
                    task.descsOrImage = desc = this.resourceManager.get((DeviceResourceDescriptor)((ImageDescriptor)desc));
                }
                catch (DeviceResourceException e) {
                    if (status == null) {
                        status = new MultiStatus("org.simantics.browsing.ui.swt", 0, "Problems loading images:", null);
                    }
                    status.add((IStatus)new Status(4, "org.simantics.browsing.ui.swt", "Image descriptor loading failed: " + desc, (Throwable)e));
                }
            }
            ++n2;
        }
        final ImageTask[] _tasks = tasks;
        this.thread.asyncExec(new Runnable(){

            @Override
            public void run() {
                GraphExplorerImpl2.this.setImages(_tasks);
            }
        });
        return status != null ? status : Status.OK_STATUS;
    }

    void setImages(ImageTask[] tasks) {
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            if (task != null) {
                this.setImage(task);
            }
            ++n2;
        }
    }

    void setImage(ImageTask task) {
        if (!task.node.isDisposed()) {
            this.update(task.node, 0);
        }
    }

    private void printTree(TreeNode node, int depth) {
        String s = "";
        int i = 0;
        while (i < depth) {
            s = String.valueOf(s) + "  ";
            ++i;
        }
        s = String.valueOf(s) + node;
        System.out.println(s);
        int d = depth + 1;
        for (TreeNode n : node.getChildren()) {
            this.printTree(n, d);
        }
    }

    public Object getClicked(Object event) {
        Point point;
        MouseEvent e = (MouseEvent)event;
        Tree tree = (Tree)e.getSource();
        TreeItem item = tree.getItem(point = new Point(e.x, e.y));
        if (item == null) {
            return null;
        }
        Object data = item.getData();
        return data;
    }

    private class CustomModifierEditor
    extends CellEditor
    implements ICellEditorValidator,
    DisposeListener {
        private Labeler.CustomModifier modifier;
        private TreeNode node;
        private NodeContext context;
        private int columnIndex;
        private Composite control;
        private Control origControl;

        public CustomModifierEditor(Composite parent, Labeler.CustomModifier modifier, TreeNode node, int columnIndex) {
            this.modifier = modifier;
            this.node = node;
            this.context = node.getContext();
            this.columnIndex = columnIndex;
            this.setValidator(this);
            this.create(parent);
        }

        protected Control createControl(Composite parent) {
            this.control = new Composite(parent, 0);
            this.control.setLayout((Layout)new FillLayout());
            this.origControl = (Control)this.modifier.createControl((Object)this.control, null, this.columnIndex, this.context);
            return this.control;
        }

        protected Object doGetValue() {
            return this.modifier.getValue();
        }

        protected void doSetValue(Object value) {
        }

        private void reCreate() {
            this.modifier = (Labeler.CustomModifier)GraphExplorerImpl2.this.getModifier(this.node, this.columnIndex);
            if (this.control != null && !this.control.isDisposed()) {
                if (!this.origControl.isDisposed()) {
                    this.origControl.dispose();
                }
                this.origControl = (Control)this.modifier.createControl((Object)this.control, null, this.columnIndex, this.context);
                this.origControl.addDisposeListener((DisposeListener)this);
            }
        }

        protected void doSetFocus() {
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setFocus();
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == this.origControl) {
                this.reCreate();
            }
        }

        public String isValid(Object value) {
            return this.modifier.isValid((String)value);
        }
    }

    private static class DummyCache
    extends GECache2 {
        private DummyCache() {
        }

        @Override
        public <T> IGECache.IGECacheEntry getEntry(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> IGECache.IGECacheEntry put(NodeContext context, NodeContext.CacheKey<T> key, T value) {
            return null;
        }

        @Override
        public <T> void putTreeReference(NodeContext context, NodeContext.CacheKey<T> key, UIElementReference reference) {
        }

        @Override
        public <T> T get(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> Set<UIElementReference> getTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> void remove(NodeContext context, NodeContext.CacheKey<T> key) {
        }

        @Override
        public <T> Set<UIElementReference> removeTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public boolean isShown(NodeContext context) {
            return false;
        }

        @Override
        public void incRef(NodeContext context) {
        }

        @Override
        public void decRef(NodeContext context) {
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }

    private class EnumModifierEditor
    extends ComboBoxCellEditor {
        List<String> values;

        public EnumModifierEditor(Composite parent, Labeler.EnumerationModifier modifier) {
            super(parent, modifier.getValues().toArray(new String[modifier.getValues().size()]), 8);
            this.values = modifier.getValues();
            this.setValidator(new ModifierValidator((Labeler.Modifier)modifier));
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)this.values.indexOf(value));
        }

        protected Object doGetValue() {
            return this.values.get((Integer)super.doGetValue());
        }
    }

    private class EnumModifierEditor2
    extends ComboBoxCellEditor2 {
        List<String> values;

        public EnumModifierEditor2(Composite parent, Labeler.EnumerationModifier modifier) {
            super(parent, modifier.getValues().toArray(new String[modifier.getValues().size()]), 8);
            this.values = modifier.getValues();
            this.setValidator(new ModifierValidator((Labeler.Modifier)modifier));
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(this.values.indexOf(value));
        }

        @Override
        protected Object doGetValue() {
            return this.values.get((Integer)super.doGetValue());
        }
    }

    private static class GECache2
    implements IGECache {
        final HashMap<GECacheKey, IGECache.IGECacheEntry> entries = new HashMap();
        final HashMap<GECacheKey, Set<UIElementReference>> treeReferences = new HashMap();
        final HashMap<NodeContext, Set<GECacheKey>> keyRefs = new HashMap();
        NodeContext getNC = new NodeContext(){

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }

            public <T> T getConstant(NodeContext.ConstantKey<T> key) {
                return null;
            }

            public Set<NodeContext.ConstantKey<?>> getKeys() {
                return Collections.emptySet();
            }
        };
        NodeContext.CacheKey<?> getCK = new NodeContext.CacheKey<Object>(){

            public Object processorIdenfitier() {
                return this;
            }
        };
        GECacheKey getKey = new GECacheKey(this.getNC, this.getCK);
        private TObjectIntHashMap<NodeContext> references = new TObjectIntHashMap();

        private GECache2() {
        }

        private void addKey(GECacheKey key) {
            Set<GECacheKey> refs = this.keyRefs.get(key.context);
            if (refs != null) {
                refs.add(key);
            } else {
                refs = new HashSet<GECacheKey>();
                refs.add(key);
                this.keyRefs.put(key.context, refs);
            }
        }

        private void removeKey(GECacheKey key) {
            Set<GECacheKey> refs = this.keyRefs.get(key.context);
            if (refs != null) {
                refs.remove(key);
            }
        }

        public <T> IGECache.IGECacheEntry put(NodeContext context, NodeContext.CacheKey<T> key, T value) {
            IGECache.GECacheEntry entry = new IGECache.GECacheEntry(context, key, value);
            GECacheKey gekey = new GECacheKey(context, key);
            this.entries.put(gekey, (IGECache.IGECacheEntry)entry);
            this.addKey(gekey);
            return entry;
        }

        public <T> T get(NodeContext context, NodeContext.CacheKey<T> key) {
            this.getKey.setValues(context, key);
            IGECache.IGECacheEntry entry = this.entries.get(this.getKey);
            if (entry == null) {
                return null;
            }
            return (T)entry.getValue();
        }

        public <T> IGECache.IGECacheEntry getEntry(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            return this.entries.get(this.getKey);
        }

        public <T> void remove(NodeContext context, NodeContext.CacheKey<T> key) {
            this.getKey.setValues(context, key);
            this.entries.remove(this.getKey);
            this.removeKey(this.getKey);
        }

        public <T> Set<UIElementReference> getTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            return this.treeReferences.get(this.getKey);
        }

        public <T> void putTreeReference(NodeContext context, NodeContext.CacheKey<T> key, UIElementReference reference) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            Set<UIElementReference> refs = this.treeReferences.get(this.getKey);
            if (refs != null) {
                refs.add(reference);
            } else {
                refs = new HashSet<UIElementReference>(4);
                refs.add(reference);
                GECacheKey gekey = new GECacheKey(this.getKey);
                this.treeReferences.put(gekey, refs);
                this.addKey(gekey);
            }
        }

        public <T> Set<UIElementReference> removeTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            this.removeKey(this.getKey);
            return this.treeReferences.remove(this.getKey);
        }

        public boolean isShown(NodeContext context) {
            return this.references.get((Object)context) > 0;
        }

        public void incRef(NodeContext context) {
            int exist = this.references.get((Object)context);
            this.references.put((Object)context, exist + 1);
        }

        public void decRef(NodeContext context) {
            int exist = this.references.get((Object)context);
            this.references.put((Object)context, exist - 1);
            if (exist == 1) {
                this.references.remove((Object)context);
            }
        }

        public void dispose() {
            this.references.clear();
            this.entries.clear();
            this.treeReferences.clear();
            this.keyRefs.clear();
        }

        public void dispose(NodeContext context) {
            Set<GECacheKey> keys = this.keyRefs.remove(context);
            if (keys != null) {
                for (GECacheKey key : keys) {
                    this.entries.remove(key);
                    this.treeReferences.remove(key);
                }
            }
        }
    }

    private static final class GECacheKey {
        private NodeContext context;
        private NodeContext.CacheKey<?> key;
        private int hash;

        GECacheKey(NodeContext context, NodeContext.CacheKey<?> key) {
            this.setValues(context, key);
        }

        GECacheKey(GECacheKey other) {
            this.setValues(other.context, other.key);
        }

        void setValues(NodeContext context, NodeContext.CacheKey<?> key) {
            this.context = context;
            this.key = key;
            if (context == null || key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
            this.hash = this.calcHash();
        }

        private int calcHash() {
            return this.context.hashCode() ^ this.key.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            GECacheKey i = (GECacheKey)object;
            return this.key.equals(i.key) && this.context.equals(i.context);
        }
    }

    private class GeEditingSupport
    extends EditingSupport {
        private Object lastElement;
        private Labeler.Modifier lastModifier;
        private int columnIndex;

        public GeEditingSupport(ColumnViewer viewer, int columnIndex) {
            super(viewer);
            this.columnIndex = columnIndex;
        }

        protected boolean canEdit(Object element) {
            if (GraphExplorerImpl2.this.filterSelectionEdit && !GraphExplorerImpl2.this.selectedNodes.contains(element)) {
                return false;
            }
            this.lastElement = null;
            Labeler.Modifier modifier = this.getModifier((TreeNode)element);
            return modifier != null;
        }

        protected CellEditor getCellEditor(Object element) {
            TreeNode node = (TreeNode)element;
            Labeler.Modifier modifier = this.getModifier((TreeNode)element);
            NodeContext context = node.getContext();
            if (modifier instanceof Labeler.DialogModifier) {
                return this.performDialogEditing(context, (Labeler.DialogModifier)modifier);
            }
            if (modifier instanceof Labeler.CustomModifier) {
                return this.startCustomEditing(node, (Labeler.CustomModifier)modifier);
            }
            if (modifier instanceof Labeler.EnumerationModifier) {
                return this.startEnumerationEditing((Labeler.EnumerationModifier)modifier);
            }
            return this.startTextEditing(modifier);
        }

        protected Object getValue(Object element) {
            Labeler.Modifier modifier = this.getModifier((TreeNode)element);
            return modifier.getValue();
        }

        protected void setValue(Object element, Object value) {
            Labeler.Modifier modifier = this.getModifier((TreeNode)element);
            if (!(modifier instanceof Labeler.CustomModifier)) {
                modifier.modify((String)value);
            }
        }

        CellEditor startTextEditing(Labeler.Modifier modifier) {
            ValidatedTextEditor editor = new ValidatedTextEditor((Composite)GraphExplorerImpl2.this.viewer.getTree());
            editor.setValidator(new ModifierValidator(modifier));
            return editor;
        }

        CellEditor startEnumerationEditing(Labeler.EnumerationModifier modifier) {
            if (SimanticsUI.isLinuxGTK()) {
                return new EnumModifierEditor((Composite)GraphExplorerImpl2.this.viewer.getTree(), modifier);
            }
            return new EnumModifierEditor2((Composite)GraphExplorerImpl2.this.viewer.getTree(), modifier);
        }

        CellEditor performDialogEditing(final NodeContext context, final Labeler.DialogModifier modifier) {
            DialogCellEditor editor = new DialogCellEditor((Composite)GraphExplorerImpl2.this.viewer.getTree()){
                String res;
                {
                    super($anonymous0);
                    this.res = null;
                }

                protected Object openDialogBox(Control cellEditorWindow) {
                    Semaphore sem = new Semaphore(1);
                    Consumer<String> callback = result -> {
                        this.res = result;
                        sem.release();
                    };
                    String status = modifier.query((Object)cellEditorWindow, null, GeEditingSupport.this.columnIndex, context, callback);
                    if (status != null) {
                        return null;
                    }
                    try {
                        sem.acquire();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.res;
                }
            };
            editor.setValidator((ICellEditorValidator)new ModifierValidator((Labeler.Modifier)modifier));
            return editor;
        }

        CellEditor startCustomEditing(TreeNode node, Labeler.CustomModifier modifier) {
            CustomModifierEditor editor = new CustomModifierEditor((Composite)GraphExplorerImpl2.this.viewer.getTree(), modifier, node, this.columnIndex);
            return editor;
        }

        private Labeler.Modifier getModifier(TreeNode element) {
            if (element == this.lastElement) {
                return this.lastModifier;
            }
            this.lastModifier = GraphExplorerImpl2.this.getModifier(element, this.columnIndex);
            this.lastElement = element;
            return this.lastModifier;
        }
    }

    private static class GeViewerContentProvider
    implements ITreeContentProvider {
        private GeViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object element) {
            TreeNode node = (TreeNode)element;
            return node.getChildren().toArray();
        }

        public Object getParent(Object element) {
            TreeNode node = (TreeNode)element;
            return node.getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class GeViewerContext
    extends AbstractDisposable
    implements IGraphExplorerContext {
        private GraphExplorerImpl2 ge;
        int queryIndent = 0;
        GECache2 cache = new GECache2();
        AtomicBoolean propagating = new AtomicBoolean(false);
        Object propagateList = new Object();
        Object propagate = new Object();
        List<Runnable> scheduleList = new ArrayList<Runnable>();
        final Deque<Integer> activity = new LinkedList<Integer>();
        int activityInt = 0;
        AtomicReference<Runnable> currentQueryUpdater = new AtomicReference();
        Map<NodeContext, Boolean> autoExpanded = new WeakHashMap<NodeContext, Boolean>();
        Runnable QUERY_UPDATE_SCHEDULER = new Runnable(){

            @Override
            public void run() {
                Runnable r = currentQueryUpdater.getAndSet(null);
                if (r != null) {
                    r.run();
                }
            }
        };

        public GeViewerContext(GraphExplorerImpl2 ge) {
            this.ge = ge;
        }

        protected void doDispose() {
            this.autoExpanded.clear();
        }

        public IGECache getCache() {
            return this.cache;
        }

        public int queryIndent() {
            return this.queryIndent;
        }

        public int queryIndent(int offset) {
            this.queryIndent += offset;
            return this.queryIndent;
        }

        public <T> NodeQueryProcessor<T> getProcessor(Object o) {
            if (this.ge == null) {
                return null;
            }
            return this.ge.processors.get(o);
        }

        public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(Object o) {
            return this.ge.primitiveProcessors.get(o);
        }

        public <T> DataSource<T> getDataSource(Class<T> clazz) {
            return this.ge.dataSources.get(clazz);
        }

        public void update(UIElementReference ref) {
            if (ref instanceof ViewerCellReference) {
                ViewerCellReference tiref = (ViewerCellReference)ref;
                Object element = tiref.getElement();
                int columnIndex = tiref.getColumn();
                this.ge.update((TreeNode)element, columnIndex);
            } else if (ref instanceof ViewerRowReference) {
                ViewerRowReference rref = (ViewerRowReference)ref;
                Object element = rref.getElement();
                this.ge.update((TreeNode)element);
            } else {
                throw new IllegalArgumentException("Ui Reference is unknkown " + ref);
            }
        }

        public Object getPropagateLock() {
            return this.propagate;
        }

        public Object getPropagateListLock() {
            return this.propagateList;
        }

        public boolean isPropagating() {
            return this.propagating.get();
        }

        public void setPropagating(boolean b) {
            this.propagating.set(b);
        }

        public List<Runnable> getScheduleList() {
            return this.scheduleList;
        }

        public void setScheduleList(List<Runnable> list) {
            this.scheduleList = list;
        }

        public Deque<Integer> getActivity() {
            return this.activity;
        }

        public void setActivityInt(int i) {
            this.activityInt = i;
        }

        public int getActivityInt() {
            return this.activityInt;
        }

        public void scheduleQueryUpdate(Runnable r) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            if (this.currentQueryUpdater.compareAndSet(null, r)) {
                this.ge.queryUpdateScheduler.execute(this.QUERY_UPDATE_SCHEDULER);
            }
        }

        public void dispose() {
            this.cache.dispose();
            this.cache = new DummyCache();
            this.scheduleList.clear();
            this.autoExpanded.clear();
            this.autoExpanded = null;
            this.ge = null;
        }
    }

    private class GeViewerLabelProvider
    extends CellLabelProvider {
        private TreeNode node;
        private Labeler labeler;
        private Imager imager;
        Collection<LabelDecorator> labelDecorators;
        Collection<ImageDecorator> imageDecorators;
        Map<String, String> labels;
        Map<String, String> runtimeLabels;

        private GeViewerLabelProvider() {
        }

        public void update(ViewerCell cell) {
            TreeNode node = (TreeNode)cell.getElement();
            NodeContext ctx = node.getContext();
            int columnIndex = cell.getColumnIndex();
            String columnKey = GraphExplorerImpl2.this.columns[columnIndex].getKey();
            if (node != this.node || columnIndex == 0) {
                this.node = node;
                GENodeQueryManager manager = node.getManager();
                this.labeler = (Labeler)manager.query(ctx, BuiltinKeys.SELECTED_LABELER);
                this.imager = (Imager)manager.query(ctx, BuiltinKeys.SELECTED_IMAGER);
                this.labelDecorators = (Collection)manager.query(ctx, BuiltinKeys.LABEL_DECORATORS);
                this.imageDecorators = (Collection)manager.query(ctx, BuiltinKeys.IMAGE_DECORATORS);
                if (this.labeler != null) {
                    this.labels = this.labeler.getLabels();
                    this.runtimeLabels = this.labeler.getRuntimeLabels();
                } else {
                    this.labels = null;
                    this.runtimeLabels = null;
                }
            }
            this.setText(cell, columnKey);
            this.setImage(cell, columnKey);
        }

        void setImage(ViewerCell cell, String columnKey) {
            if (this.imager != null) {
                Object descOrImage = null;
                boolean hasUncachedImages = false;
                ImageDescriptor desc = (ImageDescriptor)this.imager.getImage(columnKey);
                if (desc != null) {
                    Object img;
                    int index = 0;
                    if (!this.imageDecorators.isEmpty()) {
                        for (ImageDecorator id : this.imageDecorators) {
                            ImageDescriptor ds = (ImageDescriptor)id.decorateImage((Object)desc, columnKey, index);
                            if (ds == null) continue;
                            desc = ds;
                        }
                    }
                    if ((img = GraphExplorerImpl2.this.localResourceManager.find((DeviceResourceDescriptor)desc)) == null) {
                        img = GraphExplorerImpl2.this.resourceManager.find((DeviceResourceDescriptor)desc);
                    }
                    descOrImage = img != null ? img : desc;
                    hasUncachedImages |= img == null;
                }
                if (!hasUncachedImages) {
                    cell.setImage((Image)descOrImage);
                } else {
                    this.queueImageTask(this.node, new ImageTask(this.node, descOrImage));
                }
            } else {
                cell.setImage(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueImageTask(TreeNode node, ImageTask task) {
            Map<TreeNode, ImageTask> map = GraphExplorerImpl2.this.imageTasks;
            synchronized (map) {
                GraphExplorerImpl2.this.imageTasks.put(node, task);
            }
            GraphExplorerImpl2.this.imageLoaderJob.scheduleIfNecessary(100L);
        }

        void setText(ViewerCell cell, String key) {
            if (this.labeler != null) {
                String s = null;
                if (this.runtimeLabels != null) {
                    s = this.runtimeLabels.get(key);
                }
                if (s == null) {
                    s = this.labels.get(key);
                }
                if (s != null) {
                    FontDescriptor font = GraphExplorerImpl2.this.originalFont;
                    ColorDescriptor bg = GraphExplorerImpl2.this.originalBackground;
                    ColorDescriptor fg = GraphExplorerImpl2.this.originalForeground;
                    if (!this.labelDecorators.isEmpty()) {
                        int index = 0;
                        for (LabelDecorator ld : this.labelDecorators) {
                            ColorDescriptor dfg;
                            ColorDescriptor dbg;
                            FontDescriptor dfont;
                            String ds = ld.decorateLabel(s, key, index);
                            if (ds != null) {
                                s = ds;
                            }
                            if ((dfont = (FontDescriptor)ld.decorateFont((Object)font, key, index)) != null) {
                                font = dfont;
                            }
                            if ((dbg = (ColorDescriptor)ld.decorateBackground((Object)bg, key, index)) != null) {
                                bg = dbg;
                            }
                            if ((dfg = (ColorDescriptor)ld.decorateForeground((Object)fg, key, index)) == null) continue;
                            fg = dfg;
                        }
                    }
                    if (font != GraphExplorerImpl2.this.originalFont) {
                        cell.setFont((Font)GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)font));
                    } else {
                        cell.setFont((Font)(GraphExplorerImpl2.this.originalFont != null ? GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)GraphExplorerImpl2.this.originalFont) : null));
                    }
                    if (bg != GraphExplorerImpl2.this.originalBackground) {
                        cell.setBackground((Color)GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)bg));
                    } else {
                        cell.setBackground((Color)(GraphExplorerImpl2.this.originalBackground != null ? GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)GraphExplorerImpl2.this.originalBackground) : null));
                    }
                    if (fg != GraphExplorerImpl2.this.originalForeground) {
                        cell.setForeground((Color)GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)fg));
                    } else {
                        cell.setForeground((Color)(GraphExplorerImpl2.this.originalForeground != null ? GraphExplorerImpl2.this.localResourceManager.get((DeviceResourceDescriptor)GraphExplorerImpl2.this.originalForeground) : null));
                    }
                    cell.setText(s);
                }
            } else {
                cell.setText("<no label>");
            }
        }
    }

    private static class GraphExplorerPostSelectionProvider
    implements IPostSelectionProvider {
        private GraphExplorerImpl2 ge;

        GraphExplorerPostSelectionProvider(GraphExplorerImpl2 ge) {
            this.ge = ge;
        }

        void dispose() {
            this.ge = null;
        }

        public void setSelection(ISelection selection) {
            if (this.ge == null) {
                return;
            }
            this.ge.setSelection(selection, false);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removeSelectionChangedListener(listener);
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addPostSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.isDisposed()) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addPostSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addPostSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removePostSelectionChangedListener(listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.viewer.getTree().isDisposed() || this.ge.selectionProvider == null) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.ge == null) {
                return StructuredSelection.EMPTY;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".getSelection called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.viewer.getTree().isDisposed() || this.ge.selectionProvider == null) {
                return StructuredSelection.EMPTY;
            }
            return this.ge.selectionProvider.getSelection();
        }
    }

    static class ImageTask {
        TreeNode node;
        Object descsOrImage;

        public ImageTask(TreeNode node, Object descsOrImage) {
            this.node = node;
            this.descsOrImage = descsOrImage;
        }
    }

    static class ModifierValidator
    implements ICellEditorValidator {
        private Labeler.Modifier modifier;

        public ModifierValidator(Labeler.Modifier modifier) {
            this.modifier = modifier;
        }

        public String isValid(Object value) {
            return this.modifier.isValid((String)value);
        }
    }

    static class TransientStateImpl
    implements GraphExplorer.TransientExplorerState {
        private Integer activeColumn = null;

        TransientStateImpl() {
        }

        public synchronized Integer getActiveColumn() {
            return this.activeColumn;
        }

        public synchronized void setActiveColumn(Integer column) {
            this.activeColumn = column;
        }
    }

    private class TreeNode
    implements IAdaptable {
        private NodeContext context;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();
        private GENodeQueryManager manager;

        private TreeNode(NodeContext context) {
            if (context == null) {
                throw new NullPointerException();
            }
            this.context = context;
            GraphExplorerImpl2.this.contextToNodeMap.add((Object)context, (Object)this);
            this.manager = new GENodeQueryManager((IGraphExplorerContext)GraphExplorerImpl2.this.explorerContext, null, null, (UIElementReference)ViewerRowReference.create(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TreeNode> getChildren() {
            List<TreeNode> list = this.children;
            synchronized (list) {
                return this.children;
            }
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public NodeContext getContext() {
            return this.context;
        }

        public GENodeQueryManager getManager() {
            return this.manager;
        }

        public TreeNode addChild(NodeContext context) {
            TreeNode child = new TreeNode(context);
            child.parent = this;
            this.children.add(child);
            return child;
        }

        public TreeNode addChild(int index, NodeContext context) {
            TreeNode child = new TreeNode(context);
            child.parent = this;
            this.children.add(index, child);
            return child;
        }

        public TreeNode setChild(int index, NodeContext context) {
            TreeNode child = new TreeNode(context);
            child.parent = this;
            this.children.set(index, child);
            return child;
        }

        public int distanceToRoot() {
            int i = 0;
            TreeNode n = this.getParent();
            while (n != null) {
                n = n.getParent();
                ++i;
            }
            return i;
        }

        public void dispose() {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            this.dispose2();
        }

        public void dispose2() {
            this.parent = null;
            for (TreeNode n : this.children) {
                n.dispose2();
            }
            this.clearCache();
            this.children.clear();
            GraphExplorerImpl2.this.contextToNodeMap.remove((Object)this.context, (Object)this);
            this.context = null;
            this.manager.dispose();
            this.manager = null;
        }

        private void clearCache() {
            GECache2 cache;
            if (GraphExplorerImpl2.this.explorerContext != null && (cache = GraphExplorerImpl2.this.explorerContext.cache) != null) {
                cache.dispose(this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateChildren() {
            if (this.context == null) {
                throw new IllegalStateException("Node is disposed.");
            }
            NodeContext[] childContexts = (NodeContext[])this.manager.query(this.context, BuiltinKeys.FINAL_CHILDREN);
            boolean modified = false;
            List<TreeNode> list = this.children;
            synchronized (list) {
                int oldCount = this.children.size();
                BijectionMap indexes = new BijectionMap();
                HashSet<Integer> mapped = new HashSet<Integer>();
                boolean reorder = false;
                int i = 0;
                while (i < oldCount) {
                    NodeContext oldCtx = this.children.get((int)i).context;
                    int j = 0;
                    while (j < childContexts.length) {
                        if (!mapped.contains(j) && oldCtx.equals(childContexts[j])) {
                            indexes.map((Object)i, (Object)j);
                            mapped.add(j);
                            if (i == j) break;
                            reorder = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (childContexts.length != oldCount || reorder || childContexts.length != indexes.size()) {
                    TreeNode n;
                    int i2;
                    modified = true;
                    ArrayList<TreeNode> oldChildren = new ArrayList<TreeNode>(oldCount);
                    oldChildren.addAll(this.children);
                    if (childContexts.length >= oldCount) {
                        i2 = 0;
                        while (i2 < oldCount) {
                            Integer oldIndex = (Integer)indexes.getLeft((Object)i2);
                            if (oldIndex == null) {
                                this.setChild(i2, childContexts[i2]);
                            } else {
                                n = (TreeNode)oldChildren.get(oldIndex);
                                this.children.set(i2, n);
                            }
                            ++i2;
                        }
                        i2 = oldCount;
                        while (i2 < childContexts.length) {
                            this.addChild(childContexts[i2]);
                            ++i2;
                        }
                    } else {
                        i2 = 0;
                        while (i2 < childContexts.length) {
                            Integer oldIndex = (Integer)indexes.getLeft((Object)i2);
                            if (oldIndex == null) {
                                this.setChild(i2, childContexts[i2]);
                            } else {
                                n = (TreeNode)oldChildren.get(oldIndex);
                                this.children.set(i2, n);
                            }
                            ++i2;
                        }
                        i2 = oldCount - 1;
                        while (i2 >= childContexts.length) {
                            this.children.remove(i2);
                            --i2;
                        }
                    }
                    i2 = 0;
                    while (i2 < oldChildren.size()) {
                        if (!indexes.containsLeft((Object)i2)) {
                            ((TreeNode)oldChildren.get(i2)).dispose2();
                        }
                        ++i2;
                    }
                }
            }
            return modified;
        }

        public boolean isDisposed() {
            return this.context == null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == NodeContext.class) {
                return (T)this.context;
            }
            return (T)this.context.getAdapter(adapter);
        }
    }

    private static class TreeNodeIsExpandedProcessor
    extends AbstractPrimitiveQueryProcessor<Boolean>
    implements IsExpandedProcessor,
    ProcessorLifecycle {
        private final HashSet<NodeContext> expanded = new HashSet();
        private final HashMap<NodeContext, PrimitiveQueryUpdater> expandedQueries = new HashMap();
        private Tree tree;
        Listener treeListener = new Listener(){

            public void handleEvent(Event event) {
                TreeNode node = (TreeNode)event.item.getData();
                NodeContext context = node.getContext();
                switch (event.type) {
                    case 17: {
                        this.nodeStatusChanged(context, true);
                        break;
                    }
                    case 18: {
                        this.nodeStatusChanged(context, false);
                    }
                }
            }
        };

        public Object getIdentifier() {
            return BuiltinKeys.IS_EXPANDED;
        }

        public String toString() {
            return "IsExpandedProcessor";
        }

        public Boolean query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Boolean> key) {
            boolean isExpanded = this.expanded.contains(context);
            this.expandedQueries.put(context, updater);
            return isExpanded;
        }

        public Collection<NodeContext> getExpanded() {
            return new HashSet<NodeContext>(this.expanded);
        }

        public boolean getExpanded(NodeContext context) {
            return this.expanded.contains(context);
        }

        public boolean setExpanded(NodeContext context, boolean expanded) {
            return this._setExpanded(context, expanded);
        }

        public boolean replaceExpanded(NodeContext context, boolean expanded) {
            return this.nodeStatusChanged(context, expanded);
        }

        private boolean _setExpanded(NodeContext context, boolean expanded) {
            if (expanded) {
                return this.expanded.add(context);
            }
            return this.expanded.remove(context);
        }

        protected boolean nodeStatusChanged(NodeContext context, boolean expanded) {
            boolean result = this._setExpanded(context, expanded);
            PrimitiveQueryUpdater updater = this.expandedQueries.get(context);
            if (updater != null) {
                updater.scheduleReplace(context, BuiltinKeys.IS_EXPANDED, (Object)expanded);
            }
            return result;
        }

        public void attached(GraphExplorer explorer) {
            Object control = explorer.getControl();
            if (control instanceof Tree) {
                this.tree = (Tree)control;
                this.tree.addListener(17, this.treeListener);
                this.tree.addListener(18, this.treeListener);
            } else {
                System.out.println("WARNING: " + ((Object)((Object)this)).getClass().getSimpleName() + " attached to unsupported control: " + control);
            }
        }

        public void clear() {
            this.expanded.clear();
            this.expandedQueries.clear();
        }

        public void detached(GraphExplorer explorer) {
            this.clear();
            if (this.tree != null) {
                this.tree.removeListener(17, this.treeListener);
                this.tree.removeListener(18, this.treeListener);
                this.tree = null;
            }
        }
    }

    private class UpdateItem {
        TreeNode element;
        int columnIndex;

        public UpdateItem(TreeNode element) {
            this(element, -1);
        }

        public UpdateItem(TreeNode element, int columnIndex) {
            this.element = element;
            this.columnIndex = columnIndex;
            if (element != null && element.isDisposed()) {
                throw new IllegalArgumentException("Node is disposed. " + element);
            }
        }

        public void update(TreeViewer viewer) {
            if (this.element != null) {
                if (this.element.isDisposed()) {
                    return;
                }
                if (this.element.updateChildren()) {
                    viewer.refresh((Object)this.element, true);
                } else if (this.columnIndex >= 0) {
                    viewer.update((Object)this.element, new String[]{GraphExplorerImpl2.this.columns[this.columnIndex].getKey()});
                } else {
                    viewer.refresh((Object)this.element, true);
                }
                if (!this.element.isDisposed() && GraphExplorerImpl2.this.autoExpandLevel > 1 && !GraphExplorerImpl2.this.collapsedNodes.contains(this.element) && this.element.distanceToRoot() <= GraphExplorerImpl2.this.autoExpandLevel) {
                    GraphExplorerImpl2.this.expand = true;
                    viewer.setExpandedState((Object)this.element, true);
                    GraphExplorerImpl2.this.expand = false;
                }
            } else if (GraphExplorerImpl2.this.rootNode.updateChildren()) {
                viewer.refresh((Object)GraphExplorerImpl2.this.rootNode, true);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UpdateItem other = (UpdateItem)obj;
            if (this.columnIndex != other.columnIndex) {
                return false;
            }
            if (this.element != null) {
                return this.element.equals(other.element);
            }
            return other.element == null;
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.hashCode() + this.columnIndex;
            }
            return 0;
        }
    }

    static class UpdateRunner
    implements Runnable {
        final GraphExplorerImpl2 ge;

        UpdateRunner(GraphExplorerImpl2 ge, IGraphExplorerContext geContext) {
            this.ge = ge;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            HashSet<UpdateItem> items;
            if (this.ge.isDisposed()) {
                return;
            }
            ScrollBar verticalBar = this.ge.viewer.getTree().getVerticalBar();
            HashSet<UpdateItem> hashSet = this.ge.pendingItems;
            synchronized (hashSet) {
                items = this.ge.pendingItems;
                this.ge.pendingItems = new HashSet();
            }
            this.ge.viewer.getTree().setRedraw(false);
            for (UpdateItem item : items) {
                item.update(this.ge.viewer);
            }
            boolean currentlyVerticalBarVisible = verticalBar.isVisible();
            if (this.ge.verticalBarVisible != currentlyVerticalBarVisible) {
                this.ge.verticalBarVisible = currentlyVerticalBarVisible;
                this.ge.viewer.getTree().getParent().layout();
            }
            this.ge.viewer.getTree().setRedraw(true);
            HashSet<UpdateItem> hashSet2 = this.ge.pendingItems;
            synchronized (hashSet2) {
                if (!this.ge.scheduleUpdater()) {
                    this.ge.updating = false;
                }
            }
        }
    }

    private class ValidatedTextEditor
    extends TextCellEditor {
        public ValidatedTextEditor(Composite parent) {
            super(parent);
        }

        protected void editOccured(ModifyEvent e) {
            String value = this.text.getText();
            if (value == null) {
                value = "";
            }
            String typedValue = value;
            boolean oldValidState = this.isValueValid();
            boolean newValidState = this.isCorrect(typedValue);
            if (!newValidState) {
                this.text.setBackground(GraphExplorerImpl2.this.invalidModificationColor);
                this.text.setToolTipText(this.getErrorMessage());
            } else {
                this.text.setBackground(null);
                this.text.setToolTipText(null);
            }
            this.valueChanged(oldValidState, newValidState);
        }
    }
}

