/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.constraint.instructions.CombinedInstruction;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class AndInstruction
extends CombinedInstruction {
    public AndInstruction(IInstruction ... instructions) {
        super(instructions);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        Continuation ret = null;
        int instructionId = 0;
        while (instructionId < this.instructions.length) {
            Object continuation = this.instructions[instructionId].query(g, bindings);
            if (continuation == IInstruction.FAILURE) {
                while (true) {
                    if (ret == null) {
                        return IInstruction.FAILURE;
                    }
                    instructionId = ret.instructionId;
                    continuation = this.instructions[instructionId].next(g, bindings, ret.continuation);
                    if (continuation != IInstruction.FAILURE) break;
                    ret = ret.next;
                }
                if (continuation == null) {
                    ret = ret.next;
                } else {
                    ret.continuation = continuation;
                }
            } else if (continuation != null) {
                ret = new Continuation(continuation, instructionId, ret);
            }
            ++instructionId;
        }
        return ret;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object ret_) throws DatabaseException {
        Object continuation;
        int instructionId;
        Continuation ret = (Continuation)ret_;
        while (true) {
            if (ret == null) {
                return IInstruction.FAILURE;
            }
            instructionId = ret.instructionId;
            continuation = this.instructions[instructionId].next(g, bindings, ret.continuation);
            if (continuation != IInstruction.FAILURE) break;
            ret = ret.next;
        }
        if (continuation == null) {
            ret = ret.next;
        } else {
            ret.continuation = continuation;
        }
        ++instructionId;
        while (instructionId < this.instructions.length) {
            continuation = this.instructions[instructionId].query(g, bindings);
            if (continuation == IInstruction.FAILURE) {
                while (true) {
                    if (ret == null) {
                        return IInstruction.FAILURE;
                    }
                    instructionId = ret.instructionId;
                    continuation = this.instructions[instructionId].next(g, bindings, ret.continuation);
                    if (continuation != IInstruction.FAILURE) break;
                    ret = ret.next;
                }
                if (continuation == null) {
                    ret = ret.next;
                } else {
                    ret.continuation = continuation;
                }
            } else if (continuation != null) {
                ret = new Continuation(continuation, instructionId, ret);
            }
            ++instructionId;
        }
        return ret;
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("(    ");
        boolean first = true;
        IInstruction[] iInstructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction inst = iInstructionArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(",\n");
                int i = 0;
                while (i < indent + 1) {
                    b.append("     ");
                    ++i;
                }
            }
            inst.toString(b, indent + 1);
            ++n2;
        }
        b.append('\n');
        int i = 0;
        while (i < indent) {
            b.append("     ");
            ++i;
        }
        b.append(")");
    }

    static class Continuation {
        Object continuation;
        int instructionId;
        Continuation next;

        public Continuation(Object continuation, int instructionId, Continuation next) {
            this.continuation = continuation;
            this.instructionId = instructionId;
            this.next = next;
        }
    }
}

