/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.genericfileimport.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ui.genericfileimport.wizard.GenericFileImportPage;
import org.simantics.modeling.ui.genericfileimport.wizard.GenericFileImportPlan;
import org.simantics.modeling.ui.genericfileimport.wizard.Preferences;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class GenericFileImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    GenericFileImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_GENERIC_FILE_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new GenericFileImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_GENERIC_FILE_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public GenericFileImportWizard() {
        this.setWindowTitle("Import File");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new GenericFileImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import File"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    try {
                        this.importModel.sessionContext.getSession().markUndoPoint();
                        Simantics.applySCL((String)"Dropins/Core", (String)"importGenericFileToResource2", (Object[])new Object[]{this.importModel.importLocation.getAbsolutePath()});
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage("Unexpected problem importing model.\nMessage: " + cause.getMessage());
            ErrorLogger.defaultLogError((String)("File " + this.importModel.importLocation + " import failed unexpectedly. See exception for details."), (Throwable)cause);
            ExceptionUtils.showError((String)("Unexpected problem importing file.\n\n" + cause.getMessage()), (Throwable)cause);
            return false;
        }
        catch (InterruptedException e) {
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage("Import interrupted.\nMessage: " + e.getMessage());
            ErrorLogger.defaultLogError((String)("File " + this.importModel.importLocation + " import interrupted."), (Throwable)e);
            ExceptionUtils.showError((String)"File import was interrupted.", (Throwable)e);
            return false;
        }
        return true;
    }
}

