/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui;

public final class Column {
    public static final int UNDEFINED_CONTROL_WIDTH = -1;
    public static final int DEFAULT_CONTROL_WIDTH = -1;
    private final String key;
    private final String label;
    private final Align alignment;
    private final int width;
    private final String tooltip;
    private final boolean grab;
    private final int weight;

    public Column(String key) {
        this(key, key, Align.LEFT);
    }

    public Column(String key, String label, Align alignment) {
        this(key, label, alignment, -1);
    }

    public Column(String key, String label, Align alignment, int width) {
        this(key, label, alignment, width, null);
    }

    public Column(String key, Align alignment, int width) {
        this(key, key, alignment, width, null);
    }

    public Column(String key, Align alignment, int width, String tooltip) {
        this(key, key, alignment, width, tooltip);
    }

    public Column(String key, Align alignment, int width, String tooltip, boolean grab) {
        this(key, key, alignment, width, tooltip, grab);
    }

    public Column(String key, Align alignment, int width, String tooltip, boolean grab, int weight) {
        this(key, key, alignment, width, tooltip, grab, weight);
    }

    public Column(String key, String label, Align alignment, int width, String tooltip) {
        this(key, label, alignment, width, tooltip, false);
    }

    public Column(String key, String label, Align alignment, int width, String tooltip, boolean grab) {
        this(key, label, alignment, width, tooltip, grab, 1);
    }

    public Column(String key, String label, Align alignment, int width, String tooltip, boolean grab, int weight) {
        if (alignment == null) {
            throw new IllegalArgumentException("null alignment");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        this.key = key;
        this.label = label;
        this.alignment = alignment;
        this.width = width;
        this.tooltip = tooltip;
        this.grab = grab;
        this.weight = weight;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public Align getAlignment() {
        return this.alignment;
    }

    public int getWidth() {
        return this.width;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean hasGrab() {
        return this.grab;
    }

    public int getWeight() {
        return this.weight;
    }

    public Column withKey(String key) {
        return new Column(key, this.label, this.alignment, this.width, this.tooltip, this.grab, this.weight);
    }

    public Column withLabel(String label) {
        return new Column(this.key, label, this.alignment, this.width, this.tooltip, this.grab, this.weight);
    }

    public Column withAlignment(Align alignment) {
        return new Column(this.key, this.label, alignment, this.width, this.tooltip, this.grab, this.weight);
    }

    public Column withWidth(int width) {
        return new Column(this.key, this.label, this.alignment, width, this.tooltip, this.grab, this.weight);
    }

    public Column withTooltip(String tooltip) {
        return new Column(this.key, this.label, this.alignment, this.width, tooltip, this.grab, this.weight);
    }

    public Column withGrab(boolean grab) {
        return new Column(this.key, this.label, this.alignment, this.width, this.tooltip, grab, this.weight);
    }

    public Column withWeight(int weight) {
        return new Column(this.key, this.label, this.alignment, this.width, this.tooltip, this.grab, weight);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.alignment.hashCode();
        result = 31 * result + (this.grab ? 1231 : 1237);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.tooltip == null ? 0 : this.tooltip.hashCode());
        result = 31 * result + this.width;
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.grab != other.grab) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.tooltip == null ? other.tooltip != null : !this.tooltip.equals(other.tooltip)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        return this.weight == other.weight;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Column[key=");
        sb.append(this.key);
        if (!this.key.equals(this.label)) {
            sb.append(", label=");
        }
        sb.append(this.label);
        sb.append(", align=");
        sb.append((Object)this.alignment);
        sb.append(", width=");
        sb.append(this.width);
        if (!this.label.equals(this.tooltip)) {
            sb.append(", tooltip=");
            sb.append(this.tooltip);
        }
        sb.append(", grab=");
        sb.append(this.grab);
        sb.append(", weight=");
        sb.append(this.weight);
        sb.append("]");
        return sb.toString();
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

