/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DBPurgeHandler
extends AbstractHandler {
    private boolean useRestart = true;
    private boolean preventOpenEditors = true;
    private boolean emptyTrashBin = true;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        String intro;
        final String title = this.getTitle();
        if (this.preventOpenEditors) {
            IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (activeEditor != null) {
                MessageDialog.open((int)2, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)this.getEditorsOpenMessage(), (int)0);
                return null;
            }
            if (!WorkbenchUtils.closeEditors((IWorkbenchWindow)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), (boolean)true)) {
                return null;
            }
        }
        if ((intro = this.getIntroMessage()) != null && !MessageDialog.open((int)3, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)intro, (int)0)) {
            return null;
        }
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (DBPurgeHandler.this.emptyTrashBin) {
                            Layer0Utils.emptyTrashBin((IProgressMonitor)monitor);
                        } else {
                            Layer0Utils.purgeDatabase((IProgressMonitor)monitor);
                        }
                    }
                    catch (DatabaseException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (Throwable t) {
            ExceptionUtils.logAndShowError((String)this.getFailMessage(), (Throwable)t);
            return null;
        }
        Simantics.getSession().asyncRequest((Read)new Read<Collection<Resource>>(){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                Resource proj = Simantics.getProjectResource();
                Collection<Resource> models = DBPurgeHandler.this.readModels(graph, proj);
                return models;
            }
        }, (Procedure)new Procedure<Collection<Resource>>(){

            public void execute(Collection<Resource> result) {
                if (DBPurgeHandler.this.useRestart) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MessageDialog.open((int)3, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)DBPurgeHandler.this.getRestartMessage(), (int)0)) {
                                return;
                            }
                            if (!PlatformUI.getWorkbench().restart()) {
                                MessageDialog.open((int)4, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)DBPurgeHandler.this.getRestartFailedMessage(), (int)0);
                            }
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.open((int)2, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)DBPurgeHandler.this.getCompletedMessage(), (int)0);
                        }
                    });
                }
            }

            public void exception(Throwable throwable) {
                ExceptionUtils.logAndShowError((String)DBPurgeHandler.this.getFailModelsMessage(), (Throwable)throwable);
            }
        });
        return null;
    }

    public String getTitle() {
        return "DB Purge";
    }

    public String getIntroMessage() {
        String msg = "DB purge is an experimental feature, which attempts to reduce size of the DB.\n\nPlease meake sure that your workspace has a backup, or all models have been exported before running DB purge.\n\nExecuting DB purge may lead to data loss!";
        return msg;
    }

    public String getFailMessage() {
        return "DB purge has failed.";
    }

    public String getFailModelsMessage() {
        return "DB purge has failed, and we cannot retrieve models.";
    }

    public String getRestartMessage() {
        String msg = "It is recommended to restart the application after DB purge.\n\nRestart the application?";
        return msg;
    }

    public String getRestartFailedMessage() {
        return "Application failed to restart.\n\n Please restart the application manually.";
    }

    public String getCompletedMessage() {
        return "DB purge completed.";
    }

    public String getEditorsOpenMessage() {
        return "Please close all editors before running DB purge.";
    }

    public Collection<Resource> readModels(ReadGraph graph, Resource project) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
        Collection models = (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0.ConsistsOf, SIM.Model));
        return models;
    }

    public boolean isUseRestart() {
        return this.useRestart;
    }

    public void setUseRestart(boolean useRestart) {
        this.useRestart = useRestart;
    }

    public boolean isPreventOpenEditors() {
        return this.preventOpenEditors;
    }

    public void setPreventOpenEditors(boolean preventOpenEditors) {
        this.preventOpenEditors = preventOpenEditors;
    }

    public boolean isEmptyTrashBin() {
        return this.emptyTrashBin;
    }

    public void setEmptyTrashBin(boolean emptyTrashBin) {
        this.emptyTrashBin = emptyTrashBin;
    }
}

