/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.recursive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.recursive.FindRoots;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class FindParentsWithType
extends FindRoots {
    private final ReadGraph graph;
    private final Resource rootType;
    private final Layer0 L0;

    public FindParentsWithType(ReadGraph graph, Resource rootType) {
        this.graph = graph;
        this.rootType = rootType;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
    }

    @Override
    protected boolean isRoot(Resource resource) throws DatabaseException {
        return this.graph.isInstanceOf(resource, this.rootType);
    }

    @Override
    protected Collection<Resource> children(Resource resource) throws DatabaseException {
        Resource parent = this.graph.getPossibleObject(resource, this.L0.PartOf);
        if (parent != null) {
            return Collections.singletonList(parent);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(4);
        for (Statement s : this.graph.getStatements(resource, this.L0.IsWeaklyRelatedTo)) {
            Resource inverse;
            if (!s.getSubject().equals(resource) || (inverse = this.graph.getPossibleInverse(s.getPredicate())) == null || !this.graph.isSubrelationOf(inverse, this.L0.IsRelatedTo)) continue;
            result.add(s.getObject());
        }
        return result;
    }

    public static List<Resource> findParentsWithType(ReadGraph graph, Resource r, Resource type) throws DatabaseException {
        Set set = (Set)new FindParentsWithType(graph, type).get(r);
        if (set == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Resource>(set);
    }
}

