package org.simantics.scl.runtime.reporting;

import java.io.IOException;
import java.io.Writer;

public class WriterSCLReportingHandler extends AbstractSCLReportingHandler {
    private final Writer writer;

    public WriterSCLReportingHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void print(String text) {
        try {
            writer.write(text);
            writer.write('\n');
        } catch(IOException e) {
            e.printStackTrace();
        }
    }
}
