/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.platform.ui.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import org.simantics.platform.ui.SimanticsConsole;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;

public class ConsoleAppender extends AppenderBase<ILoggingEvent> {

    final private SimanticsConsole console;

    final private DateFormat formatter;

    ConsoleAppender(SimanticsConsole console) {
        assert(console != null);
        this.console = console;
        formatter = new SimpleDateFormat("dd.LL.yyyy HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    protected void append(ILoggingEvent e) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(formatter.format(new Date(e.getTimeStamp())));
        b.append("]: ");
        b.append(e.getFormattedMessage());
        console.write(b.toString());
    }
    
}