/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.wizard.IExportModel;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public abstract class ModelExportWizardPage<T extends IExportModel>
extends WizardPage {
    T exportData;
    CCombo model;
    CCombo exportLocation;
    boolean exportToFile = true;
    private List<NamedResource> models = new ArrayList<NamedResource>();
    private Button overwrite;

    public ModelExportWizardPage(String pageName, String title, ImageDescriptor titleImage, T data) {
        super(pageName, title, titleImage);
        this.exportData = data;
        this.exportToFile = ((IExportModel)data).usesFile();
    }

    protected abstract List<NamedResource> getSupportedModels(ReadGraph var1, Resource var2) throws DatabaseException;

    public String[] getFilterExtensions() {
        return new String[0];
    }

    public String[] getFilterNames() {
        return new String[0];
    }

    public void createControl(Composite parent) {
        Button browseFileButton;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("Exported &model:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the model to export.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        this.model.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IExportModel)ModelExportWizardPage.this.exportData).setModel((NamedResource)ModelExportWizardPage.this.model.getData(Integer.toString(ModelExportWizardPage.this.model.getSelectionIndex())));
                ModelExportWizardPage.this.validatePage();
            }
        });
        if (this.exportToFile) {
            new Label(container, 0).setText("&Target file:");
            this.exportLocation = new CCombo(container, 2048);
            this.exportLocation.setText("");
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
            this.exportLocation.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ModelExportWizardPage.this.validatePage();
                }
            });
            browseFileButton = new Button(container, 8);
            browseFileButton.setText("Browse...");
            browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(ModelExportWizardPage.this.getShell(), 8192);
                    dialog.setText("Choose Export Target File");
                    dialog.setFilterExtensions(ModelExportWizardPage.this.getFilterExtensions());
                    dialog.setFilterNames(ModelExportWizardPage.this.getFilterNames());
                    String loc = ModelExportWizardPage.this.exportLocation.getText();
                    dialog.setFilterPath(loc);
                    String file = dialog.open();
                    if (file == null) {
                        return;
                    }
                    ModelExportWizardPage.this.exportLocation.setText(file);
                    ModelExportWizardPage.this.validatePage();
                }
            });
        } else {
            new Label(container, 0).setText("&Target folder:");
            this.exportLocation = new CCombo(container, 2048);
            this.exportLocation.setText("");
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
            this.exportLocation.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ModelExportWizardPage.this.validatePage();
                }
            });
            browseFileButton = new Button(container, 8);
            browseFileButton.setText("Browse...");
            browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(ModelExportWizardPage.this.getShell(), 8192);
                    dialog.setText("Choose Export Target Folder");
                    String loc = ModelExportWizardPage.this.exportLocation.getText();
                    dialog.setFilterPath(loc);
                    String file = dialog.open();
                    if (file == null) {
                        return;
                    }
                    ModelExportWizardPage.this.exportLocation.setText(file);
                    ModelExportWizardPage.this.validatePage();
                }
            });
        }
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(((IExportModel)this.exportData).isOverwrite());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelExportWizardPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    protected void initializeData() throws DatabaseException {
        Resource selection = ResourceAdaptionUtils.toSingleResource((Object)((IExportModel)this.exportData).getSelection());
        Simantics.getSessionContext().getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ModelExportWizardPage.this.models = ModelExportWizardPage.this.getSupportedModels(graph, (Resource)Simantics.getProject().get());
            }
        });
        Collections.sort(this.models);
        int i = 0;
        boolean selected = false;
        for (NamedResource s : this.models) {
            this.model.add(s.getName());
            this.model.setData(String.valueOf(i), (Object)s);
            if (s.getResource().equals(selection)) {
                this.model.select(i);
                selected = true;
            }
            ++i;
        }
        if (!selected && i > 0) {
            this.model.select(0);
        }
        if (this.model.getSelectionIndex() >= 0) {
            ((IExportModel)this.exportData).setModel((NamedResource)this.model.getData(Integer.toString(this.model.getSelectionIndex())));
        }
        for (String path : ((IExportModel)this.exportData).getRecentLocations()) {
            this.exportLocation.add(path);
        }
        if (this.exportLocation.getItemCount() > 0) {
            this.exportLocation.select(0);
        }
    }

    protected void validatePage() {
        File file;
        if (((IExportModel)this.exportData).getModel() == null) {
            this.setMessage("Select model to export.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        String exportLoc = this.exportLocation.getText();
        if (this.exportToFile) {
            if (exportLoc.isEmpty()) {
                this.setMessage("Select target file.");
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            file = new File(exportLoc);
            if (file.exists() && !file.isFile()) {
                this.setErrorMessage("The target must be a file, an existing directory was given.");
                this.setPageComplete(false);
                return;
            }
            File parent = file.getParentFile();
            if (parent == null || !parent.isDirectory()) {
                this.setErrorMessage("The target directory does not exist.");
                this.setPageComplete(false);
                return;
            }
        } else {
            if (exportLoc.isEmpty()) {
                this.setMessage("Select target directory.");
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            file = new File(exportLoc);
            if (file.exists() && !file.isDirectory()) {
                this.setErrorMessage("The target must be a directory, an existing file was given.");
                this.setPageComplete(false);
                return;
            }
        }
        ((IExportModel)this.exportData).setExportLocation(file);
        ((IExportModel)this.exportData).setOverwrite(this.overwrite.getSelection());
        this.setErrorMessage(null);
        this.setMessage("Export selected model.");
        this.setPageComplete(true);
    }
}

