/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CopyContext {
    THashMap<Val, Val> valMap = new THashMap();
    THashMap<Cont, Cont> contMap = new THashMap();
    THashMap<TVar, TVar> tvarMap = new THashMap();

    public void put(Val src, Val tgt) {
        Val ret = (Val)this.valMap.put((Object)src, (Object)tgt);
        if (SCLCompilerConfiguration.DEBUG && ret != null) {
            throw new InternalCompilerError();
        }
    }

    public void put(Cont src, Cont tgt) {
        Cont ret = (Cont)this.contMap.put((Object)src, (Object)tgt);
        if (SCLCompilerConfiguration.DEBUG && ret != null) {
            throw new InternalCompilerError();
        }
    }

    public TVar[] copyParameters(TVar[] vars) {
        TVar[] result = new TVar[vars.length];
        int i = 0;
        while (i < vars.length) {
            TVar newVar;
            TVar var = vars[i];
            result[i] = newVar = Types.var(var.getKind());
            this.tvarMap.put((Object)var, (Object)newVar);
            ++i;
        }
        return result;
    }

    public BoundVar[] copy(BoundVar[] src) {
        BoundVar[] tgt = new BoundVar[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ValRef[] copy(ValRef[] src) {
        ValRef[] tgt = new ValRef[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ValRef copy(ValRef src) {
        return this.copy(src.getBinding()).createOccurrence(Types.replace(src.getTypeParameters(), this.tvarMap));
    }

    public <T extends Val> T copy(T src) {
        Val tgt = (Val)this.valMap.get(src);
        if (tgt != null) {
            return (T)tgt;
        }
        tgt = src.copy(this.tvarMap);
        this.valMap.put(src, (Object)tgt);
        return (T)tgt;
    }

    public ContRef[] copy(ContRef[] src) {
        ContRef[] tgt = new ContRef[src.length];
        int i = 0;
        while (i < src.length) {
            tgt[i] = this.copy(src[i]);
            ++i;
        }
        return tgt;
    }

    public ContRef copy(ContRef src) {
        return this.copy(src.getBinding()).createOccurrence();
    }

    public <T extends Cont> T copy(T src) {
        Cont tgt = (Cont)this.contMap.get(src);
        if (tgt != null) {
            return (T)tgt;
        }
        tgt = src.copy(this);
        this.contMap.put(src, (Object)tgt);
        return (T)tgt;
    }

    public Type copyType(Type type) {
        return type.replace(this.tvarMap);
    }
}

