/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.equation.Equation;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EEquations
extends SimplifiableExpression {
    public Equation[] equations;
    public Type effect = Types.NO_EFFECTS;

    public EEquations(Equation[] equations) {
        this.equations = equations;
    }

    public EEquations(long location, Equation[] equations) {
        this(equations);
        this.location = location;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Equation[] equationArray = this.equations;
        int n = this.equations.length;
        int n2 = 0;
        while (n2 < n) {
            Equation equation = equationArray[n2];
            equation.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Equation[] equationArray = this.equations;
            int n = this.equations.length;
            int n2 = 0;
            while (n2 < n) {
                Equation equation = equationArray[n2];
                equation.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.UNIT);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression inferType(TypingContext context) {
        context.declareEffect(this.location, this.effect);
        Equation[] equationArray = this.equations;
        int n = this.equations.length;
        int n2 = 0;
        while (n2 < n) {
            Equation equation = equationArray[n2];
            equation.checkType(context);
            ++n2;
        }
        return this;
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        return this.inferType(context);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        context.getErrorLog().log(this.location, "Equations should be transformed into other expressions before simplification phase.");
        return Expressions.tuple();
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Equation[] newEquations = new Equation[this.equations.length];
        int i = 0;
        while (i < this.equations.length) {
            newEquations[i] = this.equations[i].replace(context);
            ++i;
        }
        return new EEquations(this.location, newEquations);
    }
}

