/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.Disposable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalSelectionDragSourceListener;
import org.simantics.ui.dnd.NoImageDragSourceEffect;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintTracker;
import org.simantics.utils.ui.LayoutUtils;

public abstract class SimanticsView
extends ViewPart {
    private final WidgetSupportImpl widgetSupport = this.createSupport();
    protected IHintContext factoryHints = new HintContext();
    protected LocalResourceManager resourceManager;
    protected ISelectionListener workbenchSelectionListener;
    protected Composite parent;
    private Map<String, String> args;
    private ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    protected IMemento memento;
    private IHintTracker sessionContextTracker = new SessionContextProjectTracker();
    private SessionContextInputSource inputSource = GraphInputSources.projectSource();
    private DisposeState disposeState = DisposeState.Alive;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            SimanticsView.this.sessionContext = event.getNewValue();
            SimanticsView.this.sessionContextTracker.track((IHintContext)SimanticsView.this.sessionContext);
        }
    };
    private Object currentInput;

    protected Set<String> getBrowseContexts() {
        return Collections.emptySet();
    }

    protected WidgetSupportImpl createSupport() {
        return new WidgetSupportImpl();
    }

    protected abstract void createControls(Composite var1, IWorkbenchSite var2, ISessionContext var3, WidgetSupport var4);

    protected void activateUiContexts() {
        Set<String> contexts = this.getUiContexts();
        if (!contexts.isEmpty()) {
            IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
            for (String context : contexts) {
                cs.activateContext(context);
            }
        }
    }

    protected Transfer[] getAcceptedDataTypes() {
        return new Transfer[]{LocalObjectTransfer.getTransfer(), FileTransfer.getInstance()};
    }

    protected void handleDrop(Object data, NodeContext target) {
        Object input;
        if (target != null && (input = target.getConstant(BuiltinKeys.INPUT)) instanceof IDropTargetNode) {
            ((IDropTargetNode)input).drop(data);
        }
    }

    protected Object createDragSource(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        LocalSelectionDragSourceListener listener = new LocalSelectionDragSourceListener(selectionProvider);
        Control control = (Control)explorer.getControl();
        DragSource source = new DragSource(control, 23);
        source.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        source.addDragListener((DragSourceListener)listener);
        source.setDragSourceEffect((DragSourceEffect)new NoImageDragSourceEffect(control));
        return listener;
    }

    protected Set<String> getUiContexts() {
        return Collections.emptySet();
    }

    protected void setSessionContextTracker(IHintTracker tracker) {
        this.sessionContextTracker = tracker;
    }

    public void setInputSource(SessionContextInputSource source) {
        this.inputSource = source;
    }

    protected final SessionContextInputSource getInputSource() {
        return this.inputSource;
    }

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.contextProvider = SimanticsUI.getSessionContextProvider((Object)this.getViewSite().getWorkbenchWindow());
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
        this.setWorkbenchListeners();
        this.activateUiContexts();
        this.createControls(parent, (IWorkbenchSite)this.getSite(), this.getSessionContext(), (WidgetSupport)this.widgetSupport);
        this.attachToSession();
    }

    public void dispose() {
        this.removeWorkbenchListeners();
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.inputSource instanceof Disposable) {
                ((Disposable)this.inputSource).dispose();
            }
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.sessionContextTracker.untrack();
            this.resourceManager.dispose();
            if (this.widgetSupport instanceof Disposable) {
                ((Disposable)this.widgetSupport).dispose();
            }
            this.resourceManager = null;
            this.args = null;
            this.sessionContext = null;
            this.parent = null;
            super.dispose();
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    protected void setWorkbenchListeners() {
    }

    protected void removeWorkbenchListeners() {
        if (this.workbenchSelectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.workbenchSelectionListener);
            this.workbenchSelectionListener = null;
            this.getSite().setSelectionProvider(null);
        }
    }

    protected final void attachToSession() {
        this.contextProvider.addContextChangedListener(this.contextChangeListener);
        this.sessionContext = this.contextProvider.getSessionContext();
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
    }

    protected Column[] getColumns() {
        return null;
    }

    protected void createControls(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
    }

    protected IContextMenuInitializer getContextMenuInitializer() {
        String contextMenuId = this.getContextMenuId();
        if (contextMenuId != null) {
            return new ContextMenuInitializer(contextMenuId);
        }
        return null;
    }

    protected String getContextMenuId() {
        return null;
    }

    protected int getStyle() {
        return 2;
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver((SelectionDataResolver)new DefaultSelectionDataResolver()).create(parent, this.getStyle());
    }

    protected void addListeners(GraphExplorer explorer, IMenuManager menuManager) {
        this.addSelectionInputListeners(explorer, menuManager);
    }

    protected void addSelectionInputListeners(GraphExplorer explorer, IMenuManager menuManager) {
        explorer.addListener((Object)new DefaultKeyListener(this.contextProvider, explorer, (Function)new Function<String[]>(){

            public String[] execute(Object ... obj) {
                return new String[]{SimanticsView.this.getEditingColumn((NodeContext)obj[0])};
            }
        }));
        explorer.addListener((Object)new DefaultMouseListener(explorer));
    }

    protected String getEditingColumn(NodeContext context) {
        return "single";
    }

    protected boolean isImportantInput(Object previousInput, Object input) {
        return !Objects.equals(previousInput, input);
    }

    protected final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        if (this.sessionContext == null && context == null) {
            return false;
        }
        this.sessionContext = context;
        Object input = this.getInputSource().get(context);
        if (!this.isImportantInput(this.currentInput, input)) {
            return false;
        }
        this.currentInput = input;
        this.widgetSupport.fireInput(context, input);
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
        return true;
    }

    <T extends Control> void searchControl(Control control, Class<T> c, Set<T> result) {
        if (c.isInstance(control)) {
            result.add(control);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.searchControl(child, c, result);
                ++n2;
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISessionContextProvider.class == adapter) {
            return (T)this.getSessionContextProvider();
        }
        if (IPropertyPage.class == adapter) {
            return (T)this.getPropertyPage();
        }
        if (GraphExplorer.class == adapter) {
            HashSet composites = new HashSet();
            this.searchControl((Control)this.parent, GraphExplorerComposite.class, composites);
            if (composites.size() == 1) {
                GraphExplorerComposite gec = (GraphExplorerComposite)composites.iterator().next();
                return (T)gec.getExplorer();
            }
            return null;
        }
        return (T)super.getAdapter(adapter);
    }

    protected abstract IPropertyPage getPropertyPage();

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    SimanticsView.this.applySessionContext(SimanticsView.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

