/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.simantics.jfreechart.chart.FilteredDataset;

public class FilteringCategoryDataset
extends AbstractDataset
implements CategoryDataset,
FilteredDataset,
DatasetChangeListener {
    private static final long serialVersionUID = -4955124650051030544L;
    CategoryDataset original;
    DefaultCategoryDataset filtered;
    CategoryDataset used;
    boolean filterRows = true;
    boolean filtering = true;
    double filterFraction = 0.05;
    private Comparable other;

    public FilteringCategoryDataset(CategoryDataset dataset, Comparable other) {
        this.original = dataset;
        this.filtered = new DefaultCategoryDataset();
        this.other = other;
        this.used = this.filtered;
        this.original.addChangeListener((DatasetChangeListener)this);
        this.updateFiltered();
    }

    @Override
    public boolean isFiltering() {
        return this.filtering;
    }

    @Override
    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
        this.used = filtering ? this.filtered : this.original;
        this.fireDatasetChanged();
    }

    @Override
    public void setFilterFraction(double filterFraction) {
        this.filterFraction = filterFraction;
    }

    @Override
    public double getFilterFraction() {
        return this.filterFraction;
    }

    public void setFilterRows(boolean filterRows) {
        this.filterRows = filterRows;
    }

    public boolean isFilterRows() {
        return this.filterRows;
    }

    @Override
    public void updateFiltered() {
        this.filtered.clear();
        if (this.filterRows) {
            for (Object column : this.original.getColumnKeys()) {
                Number value;
                Double total = 0.0;
                Double other = 0.0;
                for (Object row : this.original.getRowKeys()) {
                    value = this.original.getValue((Comparable)row, (Comparable)column);
                    if (value == null) continue;
                    total = total + Math.abs(value.doubleValue());
                }
                total = total * this.filterFraction;
                for (Object row : this.original.getRowKeys()) {
                    value = this.original.getValue((Comparable)row, (Comparable)column);
                    if (value == null) continue;
                    if (Math.abs(value.doubleValue()) > total) {
                        this.filtered.addValue(value, (Comparable)row, (Comparable)column);
                        continue;
                    }
                    other = other + value.doubleValue();
                }
                if (!(Math.abs(other) > 0.0)) continue;
                this.filtered.addValue((Number)other, this.other, (Comparable)column);
            }
        } else {
            for (Object row : this.original.getRowKeys()) {
                Number value;
                Double total = 0.0;
                Double other = 0.0;
                for (Object column : this.original.getColumnKeys()) {
                    value = this.original.getValue((Comparable)row, (Comparable)column);
                    if (value == null) continue;
                    total = total + Math.abs(value.doubleValue());
                }
                total = total * this.filterFraction;
                for (Object column : this.original.getColumnKeys()) {
                    value = this.original.getValue((Comparable)row, (Comparable)column);
                    if (value == null) continue;
                    if (Math.abs(value.doubleValue()) > total) {
                        this.filtered.addValue(value, (Comparable)row, (Comparable)column);
                        continue;
                    }
                    other = other + value.doubleValue();
                }
                if (!(Math.abs(other) > 0.0)) continue;
                this.filtered.addValue((Number)other, (Comparable)row, this.other);
            }
        }
        this.fireDatasetChanged();
    }

    public int getColumnCount() {
        return this.used.getColumnCount();
    }

    public int getRowCount() {
        return this.used.getRowCount();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.used.getValue(rowKey, columnKey);
    }

    public Number getValue(int row, int column) {
        return this.used.getValue(row, column);
    }

    public List getColumnKeys() {
        return this.used.getColumnKeys();
    }

    public Comparable getColumnKey(int column) {
        return this.used.getColumnKey(column);
    }

    public List getRowKeys() {
        return this.used.getRowKeys();
    }

    public Comparable getRowKey(int row) {
        return this.used.getRowKey(row);
    }

    public int getRowIndex(Comparable key) {
        return this.used.getRowIndex(key);
    }

    public int getColumnIndex(Comparable key) {
        return this.used.getColumnIndex(key);
    }

    @Override
    public Comparable getOther() {
        return this.other;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }
}

