/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.simantics.Simantics;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.SWTAWTComponent;

public class ChartComposite2
extends SWTAWTComponent {
    private JPanel jPanel;
    private ChartPanel chartPanel;
    private IJFreeChart chart;

    public ChartComposite2(Composite parent, String chartResourceURI, int style) {
        super(parent, style);
        try {
            Resource chartResource = (Resource)Simantics.getSession().syncRequest(graph -> graph.getPossibleResource(chartResourceURI));
            if (chartResource != null) {
                this.CreateContent(chartResource);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.syncPopulate();
    }

    public ChartComposite2(Composite parent, Resource chartResource, int style) {
        super(parent, style);
        this.CreateContent(chartResource);
        this.syncPopulate();
    }

    protected ChartComposite2(Composite parent, int style) {
        super(parent, style);
    }

    protected Component createSwingComponent() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new GridLayout(1, 1));
        if (this.chartPanel != null) {
            this.jPanel.add((Component)this.chartPanel);
        }
        this.jPanel.doLayout();
        return this.jPanel;
    }

    protected void setPanel(ChartPanel panel) {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), () -> {
            if (this.jPanel == null) {
                this.chartPanel = panel;
            } else {
                this.jPanel.removeAll();
                this.chartPanel = panel;
                this.jPanel.add((Component)this.chartPanel, "Center");
                this.jPanel.add((Component)this.chartPanel);
                this.jPanel.doLayout();
            }
        });
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public IJFreeChart getChart() {
        return this.chart;
    }

    public void doDispose() {
        if (this.chart != null) {
            this.chart.dispose();
            this.chart = null;
        }
        super.doDispose();
    }

    protected Read<IJFreeChart> getChartQuery(Resource chartResource) {
        return new ChartRead(chartResource);
    }

    protected void CreateContent(Resource chartResource) {
        Simantics.getSession().asyncRequest(this.getChartQuery(chartResource), (AsyncListener)new AsyncListener<IJFreeChart>(){

            public boolean isDisposed() {
                return ChartComposite2.this.isDisposed();
            }

            public void execute(AsyncReadGraph graph, IJFreeChart chart) {
                if (ChartComposite2.this.chart != null) {
                    ChartComposite2.this.chart.dispose();
                    ChartComposite2.this.chart = null;
                }
                if (chart == null) {
                    return;
                }
                if (ChartComposite2.this.isDisposed()) {
                    chart.dispose();
                    return;
                }
                ChartComposite2.this.chart = chart;
                JFreeChart jfreeChart = chart.getChart();
                ChartPanel panel = new ChartPanel(jfreeChart, 1024, 768, 300, 200, 2048, 1536, false, false, true, true, true, true);
                ChartComposite2.this.setPanel(panel);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    protected static class ChartRead
    implements Read<IJFreeChart> {
        private Resource chartResource;

        public ChartRead(Resource chartResource) {
            this.chartResource = chartResource;
        }

        public IJFreeChart perform(ReadGraph graph) throws DatabaseException {
            if (graph.isInstanceOf(this.chartResource, JFreeChartResource.getInstance((ReadGraph)graph).Chart)) {
                return (IJFreeChart)graph.adaptUnique(this.chartResource, IJFreeChart.class);
            }
            return null;
        }
    }
}

