/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.category.CategoryDataset;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.AbstractPlot;
import org.simantics.jfreechart.chart.FilteredDataset;
import org.simantics.jfreechart.chart.IAxis;
import org.simantics.jfreechart.chart.IDataset;
import org.simantics.jfreechart.chart.PlotProperties;
import org.simantics.sysdyn.JFreeChartResource;

public class CategoryPlot
extends AbstractPlot {
    public CategoryPlot(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    @Override
    protected Plot newPlot() {
        return new org.jfree.chart.plot.CategoryPlot(null, null, null, null);
    }

    @Override
    protected void setPlotProperties(PlotProperties properties) {
        Boolean orientation;
        if (!(this.plot instanceof org.jfree.chart.plot.CategoryPlot)) {
            return;
        }
        org.jfree.chart.plot.CategoryPlot cplot = (org.jfree.chart.plot.CategoryPlot)this.plot;
        int i = 0;
        while (i < properties.ranges.size()) {
            cplot.setRangeAxis(i, (ValueAxis)properties.ranges.get(i).getAxis());
            ++i;
        }
        i = 0;
        while (i < properties.domains.size()) {
            cplot.setDomainAxis(i, (CategoryAxis)properties.domains.get(i).getAxis());
            ++i;
        }
        int i2 = 0;
        while (i2 < properties.datasets.size()) {
            IDataset dataset = properties.datasets.get(i2);
            CategoryDataset ds = (CategoryDataset)dataset.getDataset();
            cplot.setDataset(i2, ds);
            cplot.setRenderer(i2, (CategoryItemRenderer)dataset.getRenderer());
            IAxis axis = properties.rangeMappings.get(dataset);
            if (axis != null && properties.ranges.contains(axis)) {
                cplot.mapDatasetToRangeAxis(i2, properties.ranges.indexOf(axis));
            }
            if ((axis = properties.domainMappings.get(dataset)) != null && properties.ranges.contains(axis)) {
                cplot.mapDatasetToDomainAxis(i2, properties.domains.indexOf(axis));
            }
            if (ds instanceof FilteredDataset) {
                FilteredDataset f = (FilteredDataset)ds;
                Boolean useFilter = (Boolean)properties.otherProperties.get("useFilter");
                Double filterFraction = (Double)properties.otherProperties.get("filterFraction");
                if (useFilter != null && filterFraction != null) {
                    f.setFiltering(useFilter);
                    f.setFilterFraction(filterFraction * 0.01);
                    f.updateFiltered();
                } else {
                    f.setFiltering(false);
                }
            }
            ++i2;
        }
        Boolean visibleGrid = (Boolean)properties.otherProperties.get("visibleGrid");
        if (visibleGrid != null) {
            cplot.setRangeGridlinesVisible(visibleGrid.booleanValue());
            cplot.setDomainGridlinesVisible(false);
        }
        if ((orientation = (Boolean)properties.otherProperties.get("orientation")) != null) {
            if (orientation.booleanValue()) {
                cplot.setOrientation(PlotOrientation.HORIZONTAL);
            } else {
                cplot.setOrientation(PlotOrientation.VERTICAL);
            }
        }
        cplot.setInsets(new RectangleInsets(2.0, 5.0, 2.0, 2.0), false);
        cplot.setOutlineVisible(false);
        super.setPlotProperties(properties);
    }

    @Override
    protected void getOtherProperties(ReadGraph graph, PlotProperties properties) throws DatabaseException {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Boolean visibleGrid = (Boolean)graph.getPossibleRelatedValue(this.resource, jfree.Plot_visibleGrid);
        properties.otherProperties.put("visibleGrid", visibleGrid);
        Boolean orientation = (Boolean)graph.getPossibleRelatedValue(this.resource, jfree.Plot_orientation);
        properties.otherProperties.put("orientation", orientation);
        Boolean useFilter = (Boolean)graph.getPossibleRelatedValue(this.resource, JFreeChartResource.getInstance((ReadGraph)graph).Filter_used, (Binding)Bindings.BOOLEAN);
        Double filterFraction = (Double)graph.getPossibleRelatedValue(this.resource, JFreeChartResource.getInstance((ReadGraph)graph).Filter_fraction, (Binding)Bindings.DOUBLE);
        properties.otherProperties.put("useFilter", useFilter);
        properties.otherProperties.put("filterFraction", filterFraction);
    }
}

