/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.simantics.logging.LoggerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogConfigurator.class);

    private LogConfigurator() {
    }

    public static void setLoggingLevel(String level) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting logger level to {}", (Object)level);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Level ll = LogConfigurator.getLoggerLevel(level);
        List loggerList = context.getLoggerList();
        loggerList.forEach(l -> l.setLevel(ll));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loggers installed {}", (Object)loggerList);
        }
    }

    public static void setLoggingLevelForLogger(String logger, String level) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting logger level to {} for loggers {}", (Object)level, (Object)logger);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Level ll = LogConfigurator.getLoggerLevel(level);
        ch.qos.logback.classic.Logger l = context.getLogger(logger);
        l.setLevel(ll);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Logger {} level set to {}", (Object)l, (Object)ll);
        }
    }

    private static Level getLoggerLevel(String level) {
        return Level.valueOf((String)level);
    }

    public static List<LoggerLevel> listConfiguredLoggers() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        return context.getLoggerList().stream().map(l -> {
            if (l.getName().isEmpty()) {
                return null;
            }
            return new LoggerLevel((Logger)l, l.getEffectiveLevel().toString());
        }).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    public static void applyLogLevels(List<LoggerLevel> loggers) {
        loggers.forEach(l -> {
            Level level = LogConfigurator.getLoggerLevel(l.getLevel());
            Logger logger = l.getLogger();
            if (logger instanceof ch.qos.logback.classic.Logger) {
                LOGGER.info("Setting existing logger {} level to {}", (Object)l.getName(), (Object)l.getLevel());
                ch.qos.logback.classic.Logger ll = (ch.qos.logback.classic.Logger)l.getLogger();
                ll.setLevel(level);
            } else if (!l.getName().trim().isEmpty()) {
                LOGGER.info("Defining new logger {} with level {}", (Object)l.getName(), (Object)l.getLevel());
                logger = LoggerFactory.getLogger((String)l.getName());
                if (logger instanceof ch.qos.logback.classic.Logger) {
                    ch.qos.logback.classic.Logger ll = (ch.qos.logback.classic.Logger)logger;
                    ll.setLevel(level);
                }
            }
        });
    }
}

