/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.simantics.g2d.routing.algorithm1.Penalty;

public class StopSet {
    Line[] lines;
    public static final Comparator<Stop> stopComparator = new Comparator<Stop>(){

        @Override
        public int compare(Stop o1, Stop o2) {
            if (o1.y < o2.y) {
                return -1;
            }
            if (o1.y > o2.y) {
                return 1;
            }
            if (o1.x0 < o2.x0) {
                return -1;
            }
            if (o1.x0 > o2.x0) {
                return 1;
            }
            return 0;
        }
    };

    public StopSet(Collection<Stop> _stops) {
        if (_stops.isEmpty()) {
            return;
        }
        Stop[] stops = _stops.toArray(new Stop[_stops.size()]);
        Arrays.sort(stops, stopComparator);
        TIntArrayList lineBegins = new TIntArrayList();
        lineBegins.add(0);
        int i = 1;
        while (i < stops.length) {
            if (stops[i - 1].y < stops[i].y) {
                lineBegins.add(i);
            }
            ++i;
        }
        this.lines = new Line[lineBegins.size()];
        Line prev = null;
        int from = stops.length;
        int i2 = lineBegins.size() - 1;
        while (i2 >= 0) {
            int to = from;
            from = lineBegins.get(i2);
            double[] xs = new double[(to - from) * 2];
            Penalty[] penalty = new Penalty[(to - from) * 2 + 1];
            int pointCount = 0;
            int j = from;
            while (j < to) {
                Stop stop = stops[j];
                if (pointCount == 0 || xs[pointCount - 1] < stop.x0) {
                    penalty[pointCount] = null;
                    xs[pointCount++] = stop.x0;
                    penalty[pointCount] = stop.penalty;
                    xs[pointCount++] = stop.x1;
                } else if (stop.penalty.equals(penalty[pointCount - 1])) {
                    if (stop.x1 > xs[pointCount - 1]) {
                        xs[pointCount - 1] = stop.x1;
                    }
                } else if (stop.x0 == xs[pointCount - 1]) {
                    penalty[pointCount] = stop.penalty;
                    xs[pointCount++] = stop.x1;
                } else if (stop.x1 > xs[pointCount - 1]) {
                    if (stop.penalty.penalty > penalty[pointCount - 1].penalty) {
                        if (xs[pointCount - 2] == stop.x0) {
                            --pointCount;
                        } else {
                            xs[pointCount - 1] = stop.x0;
                        }
                    }
                    penalty[pointCount] = stop.penalty;
                    xs[pointCount++] = stop.x1;
                } else {
                    double cfr_ignored_0 = stop.penalty.penalty;
                    double cfr_ignored_1 = penalty[pointCount - 1].penalty;
                }
                ++j;
            }
            penalty[pointCount] = null;
            if (pointCount < xs.length) {
                xs = Arrays.copyOf(xs, pointCount);
                penalty = Arrays.copyOf(penalty, pointCount + 1);
            }
            Line[] nextLine = new Line[pointCount + 1];
            int[] nextPosition = new int[pointCount + 1];
            if (prev != null) {
                int prevI = 0;
                double[] prevXs = prev.xs;
                int j2 = 0;
                while (j2 <= pointCount) {
                    double min = j2 == 0 ? Double.NEGATIVE_INFINITY : xs[j2 - 1];
                    double max = j2 == pointCount ? Double.POSITIVE_INFINITY : xs[j2];
                    while (prevI < prevXs.length && prevXs[prevI] <= min) {
                        ++prevI;
                    }
                    Line prev2 = prev;
                    int prevI2 = prevI;
                    double[] prevXs2 = prevXs;
                    while (prev2.penalty[prevI2] == null && (prevI2 == prevXs2.length || prevXs2[prevI2] >= max)) {
                        int temp = prev2.nextPosition[prevI2];
                        prev2 = prev2.nextLine[prevI2];
                        if (prev2 == null) break;
                        prevI2 = temp;
                        prevXs2 = prev2.xs;
                        while (prevI2 < prevXs2.length && prevXs2[prevI2] <= min) {
                            ++prevI2;
                        }
                    }
                    nextLine[j2] = prev2;
                    nextPosition[j2] = prevI2;
                    ++j2;
                }
            }
            this.lines[i2] = prev = new Line(xs, stops[from].y, penalty, nextLine, nextPosition);
            --i2;
        }
    }

    public void findStops(double min, double max, double y, IStopProcedure proc) {
        if (this.lines == null) {
            proc.blockEnd(Double.POSITIVE_INFINITY);
            return;
        }
        int minJ = -1;
        int maxJ = this.lines.length;
        while (maxJ > minJ + 1) {
            int middleJ = minJ + maxJ >>> 1;
            double middleY = this.lines[middleJ].y;
            if (middleY < y) {
                minJ = middleJ;
                continue;
            }
            if (middleY > y) {
                maxJ = middleJ;
                continue;
            }
            minJ = maxJ = middleJ;
            break;
        }
        if (maxJ == this.lines.length) {
            proc.blockEnd(Double.POSITIVE_INFINITY);
        } else {
            double[] xs = this.lines[maxJ].xs;
            int minI = -1;
            int maxI = xs.length;
            while (maxI > minI + 1) {
                int middleI = minI + maxI >>> 1;
                double middleX = xs[middleI];
                if (middleX < min) {
                    minI = middleI;
                    continue;
                }
                if (middleX > min) {
                    maxI = middleI;
                    continue;
                }
                minI = maxI = middleI;
            }
            StopSet.findStops(maxI, this.lines[maxJ], min, max, y, proc);
        }
    }

    private static void findStops(int pos, Line line, double min, double max, double y, IStopProcedure proc) {
        double[] xs = line.xs;
        while (line.penalty[pos] == null && (pos == xs.length || xs[pos] >= max)) {
            int temp = line.nextPosition[pos];
            line = line.nextLine[pos];
            if (line == null) break;
            xs = line.xs;
            pos = temp;
            while (pos < xs.length && xs[pos] <= min) {
                ++pos;
            }
        }
        if (line == null) {
            proc.blockEnd(Double.POSITIVE_INFINITY);
        } else {
            if (line.y > y) {
                proc.blockEnd(line.y);
            }
            if (pos == xs.length || xs[pos] >= max) {
                proc.continuation(min, max, pos, line);
            } else {
                proc.continuation(min, xs[pos], pos, line);
                while (pos + 1 < xs.length && xs[pos + 1] < max) {
                    proc.continuation(xs[++pos - 1], xs[pos], pos, line);
                }
                proc.continuation(xs[pos], max, pos + 1, line);
            }
        }
    }

    public static void continueStop(int pos, Line line, double min, double max, IStopProcedure proc) {
        Line newLine = line.nextLine[pos];
        if (newLine == null) {
            proc.blockEnd(Double.POSITIVE_INFINITY);
        } else {
            int newPos = line.nextPosition[pos];
            double[] xs = newLine.xs;
            while (newPos < xs.length && xs[newPos] <= min) {
                ++newPos;
            }
            StopSet.findStops(newPos, newLine, min, max, line.y, proc);
        }
    }

    public static interface IStopProcedure {
        public void blockEnd(double var1);

        public void continuation(double var1, double var3, int var5, Line var6);
    }

    public static class Line {
        double[] xs;
        public double y;
        public Penalty[] penalty;
        Line[] nextLine;
        int[] nextPosition;

        public Line(double[] xs, double y, Penalty[] penalty, Line[] nextLine, int[] nextPosition) {
            this.xs = xs;
            this.y = y;
            this.penalty = penalty;
            this.nextLine = nextLine;
            this.nextPosition = nextPosition;
        }
    }

    public static class Stop {
        double x0;
        double x1;
        double y;
        Penalty penalty;

        public Stop(Penalty penalty, double x0, double x1, double y) {
            this.penalty = penalty;
            this.x0 = x0;
            this.x1 = x1;
            this.y = y;
        }
    }
}

